/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit;

import edu.colorado.phet.batteryresistorcircuit.common.paint.gauges.IGauge;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Law;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountListener;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import edu.colorado.phet.batteryresistorcircuit.volt.CurrentListener;
import edu.colorado.phet.batteryresistorcircuit.volt.WireRegion;
import edu.colorado.phet.common.phetcommon.math.DoubleSeries;
import java.util.ArrayList;
import java.util.Vector;

public class AverageCurrent
implements Law,
CoreCountListener,
VoltageListener {
    ArrayList al = new ArrayList();
    IGauge ig;
    DoubleSeries ds;
    WireRegion region;
    double resistance;
    double voltage;
    Vector listeners = new Vector();

    public void addCurrentListener(CurrentListener currentListener) {
        this.listeners.add(currentListener);
    }

    public void valueChanged(double d) {
        this.resistance = d;
    }

    public void coreCountChanged(int n) {
        this.voltage = n;
    }

    public AverageCurrent(IGauge iGauge, int n, WireRegion wireRegion) {
        this.region = wireRegion;
        this.ds = new DoubleSeries(n);
        this.ig = iGauge;
    }

    public void addParticle(WireParticle wireParticle) {
        this.al.add(wireParticle);
    }

    public void iterate(double d, System2D system2D) {
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.al.size(); ++i) {
            WireParticle wireParticle = (WireParticle)this.al.get(i);
            if (!this.region.contains(wireParticle)) continue;
            d2 += wireParticle.getVelocity() * wireParticle.getCharge();
            ++n;
        }
        if (n != 0) {
            d2 /= (double)n;
        }
        double d3 = 11.549999999999999;
        d2 = 0.0;
        double d4 = this.resistance / this.voltage * d3;
        double d5 = d2 + d4;
        this.ds.add(d5);
        double d6 = this.ds.average();
        this.ig.setValue(d6 * 0.4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CurrentListener)this.listeners.get(i)).currentChanged(d6);
        }
    }
}

