/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit;

import edu.colorado.phet.batteryresistorcircuit.AngelPaint;
import edu.colorado.phet.batteryresistorcircuit.AverageCurrent;
import edu.colorado.phet.batteryresistorcircuit.BatteryResistorCircuitResources;
import edu.colorado.phet.batteryresistorcircuit.BatteryResistorCircuitStrings;
import edu.colorado.phet.batteryresistorcircuit.Electron;
import edu.colorado.phet.batteryresistorcircuit.Resistance;
import edu.colorado.phet.batteryresistorcircuit.collisions.Collider;
import edu.colorado.phet.batteryresistorcircuit.collisions.DefaultCollisionEvent;
import edu.colorado.phet.batteryresistorcircuit.common.math.functions.Transform;
import edu.colorado.phet.batteryresistorcircuit.common.paint.BufferedImagePainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.CompositePainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.LayeredPainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.OvalPainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.PainterPanel;
import edu.colorado.phet.batteryresistorcircuit.common.paint.TextPainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.gauges.GaugeScaling;
import edu.colorado.phet.batteryresistorcircuit.common.paint.gauges.ImageGauge;
import edu.colorado.phet.batteryresistorcircuit.common.paint.gauges.Scaling;
import edu.colorado.phet.batteryresistorcircuit.common.paint.particle.ImagePainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.vector.DefaultVectorPainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.vector.VectorPainterAdapter;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.ParticleLaw;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Repaint;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.SystemRunner;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Circuit;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.AdjacentPatchCoulombForce;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.AdjacentPatchCoulombForce2;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.CoulombForce;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.CoulombForceParameters;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.Friction1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.paint.WireParticlePainter;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.paint.WirePatchPainter;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.propagators.CompositePropagator1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.propagators.DualJunction;
import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountSlider;
import edu.colorado.phet.batteryresistorcircuit.gui.ShowPainterListener;
import edu.colorado.phet.batteryresistorcircuit.gui.ShowPainters;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageSlider;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.DefaultOscillateFactory;
import edu.colorado.phet.batteryresistorcircuit.regions.AndRegion;
import edu.colorado.phet.batteryresistorcircuit.regions.PatchRegion;
import edu.colorado.phet.batteryresistorcircuit.regions.SimplePatch;
import edu.colorado.phet.batteryresistorcircuit.volt.Accel;
import edu.colorado.phet.batteryresistorcircuit.volt.BatteryDirectionChanger;
import edu.colorado.phet.batteryresistorcircuit.volt.BatteryForcePropagator;
import edu.colorado.phet.batteryresistorcircuit.volt.BatteryPainter;
import edu.colorado.phet.batteryresistorcircuit.volt.BlackbodyScale;
import edu.colorado.phet.batteryresistorcircuit.volt.Crash;
import edu.colorado.phet.batteryresistorcircuit.volt.Filament;
import edu.colorado.phet.batteryresistorcircuit.volt.RangedPropagator;
import edu.colorado.phet.batteryresistorcircuit.volt.ResetElectron;
import edu.colorado.phet.batteryresistorcircuit.volt.ResetScatterability;
import edu.colorado.phet.batteryresistorcircuit.volt.ShowInsideBattery;
import edu.colorado.phet.batteryresistorcircuit.volt.SmoothBatt;
import edu.colorado.phet.batteryresistorcircuit.volt.Spectrum;
import edu.colorado.phet.batteryresistorcircuit.volt.Turnstile;
import edu.colorado.phet.batteryresistorcircuit.volt.VoltCount;
import edu.colorado.phet.batteryresistorcircuit.volt.VoltageOnBattery;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BatteryResistorCircuitSimulationPanel
extends JPanel {
    public static int BASE_FRAME_WIDTH = 1028;
    private IClock clock;

    public BatteryResistorCircuitSimulationPanel(IClock iClock) {
        this.clock = iClock;
    }

    public void startApplication() throws IOException, FontFormatException {
        Object object;
        Object object2;
        int n;
        int n2 = 68;
        int n3 = n = 60 + n2;
        WirePatch wirePatch = new WirePatch();
        DoublePoint doublePoint = new DoublePoint(25 + n2, 120.0);
        DoublePoint doublePoint2 = new DoublePoint(700 + n2, 120.0);
        DoublePoint doublePoint3 = new DoublePoint(700 + n2, 270.0);
        DoublePoint doublePoint4 = new DoublePoint(25 + n2, 270.0);
        DoublePoint doublePoint5 = doublePoint.add(new DoublePoint(n - n2, 0.0));
        DoublePoint doublePoint6 = doublePoint2.add(new DoublePoint(-n + n2, 0.0));
        DoublePoint doublePoint7 = doublePoint4.add(new DoublePoint(n3 - n2, 0.0));
        DoublePoint doublePoint8 = doublePoint3.add(new DoublePoint(-n3 + n2, 0.0));
        wirePatch.start(doublePoint7, doublePoint4);
        wirePatch.add(doublePoint);
        wirePatch.add(doublePoint2);
        wirePatch.add(doublePoint3);
        wirePatch.add(doublePoint8);
        WirePatch wirePatch2 = new WirePatch();
        wirePatch2.start(doublePoint8, doublePoint7);
        Circuit circuit = new Circuit();
        circuit.addWirePatch(wirePatch);
        circuit.addWirePatch(wirePatch2);
        LayeredPainter layeredPainter = new LayeredPainter();
        PainterPanel painterPanel = new PainterPanel(layeredPainter);
        BasicStroke basicStroke = new BasicStroke(35.2f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(95.0f, 0, 0);
        WirePatch wirePatch3 = new WirePatch();
        wirePatch3.start(doublePoint5, doublePoint6);
        WirePatch wirePatch4 = new WirePatch();
        wirePatch4.start(doublePoint7, doublePoint4);
        wirePatch4.add(doublePoint);
        wirePatch4.add(doublePoint5);
        Color color = new Color(200, 120, 90);
        layeredPainter.addPainter(new WirePatchPainter(basicStroke, color, wirePatch4));
        WirePatch wirePatch5 = new WirePatch();
        wirePatch5.start(doublePoint6, doublePoint2);
        wirePatch5.add(doublePoint3);
        wirePatch5.add(doublePoint8);
        layeredPainter.addPainter(new WirePatchPainter(basicStroke, color, wirePatch5));
        int n4 = 14;
        double d = 10.0;
        int n5 = 400;
        Spectrum spectrum = new Spectrum(BatteryResistorCircuitResources.loadBufferedImage("spectra/spect3.jpg"), 100);
        Filament filament = new Filament(basicStroke2, wirePatch3, d * 0.6, 1.0, spectrum);
        BufferedImage bufferedImage = BatteryResistorCircuitResources.loadBufferedImage("icons/Play24.GIF");
        BlackbodyScale blackbodyScale = new BlackbodyScale(BatteryResistorCircuitResources.loadBufferedImage("spectra/fullSpectrum.jpg"), 350, 10 + n5, bufferedImage);
        spectrum.addPowerListener(blackbodyScale);
        layeredPainter.addPainter(blackbodyScale);
        float f = 660.0f;
        float f2 = 30 + n5;
        float f3 = 360.0f;
        float f4 = f2;
        PhetFont phetFont = new PhetFont(19);
        layeredPainter.addPainter(new TextPainter(BatteryResistorCircuitStrings.get("Ohm1dModule.Hot"), f, f2, phetFont, Color.black));
        layeredPainter.addPainter(new TextPainter(BatteryResistorCircuitStrings.get("Ohm1dModule.Cold"), f3, f4, phetFont, Color.white));
        layeredPainter.addPainter(filament);
        WireSystem wireSystem = new WireSystem();
        CompositePropagator1d compositePropagator1d = new CompositePropagator1d();
        double d2 = 15.0;
        double d3 = 900.0;
        double d4 = -1.3;
        CoulombForceParameters coulombForceParameters = new CoulombForceParameters(d3, d4);
        CoulombForce coulombForce = new CoulombForce(coulombForceParameters, wireSystem);
        coulombForceParameters.setMinDistance(2.0);
        double d5 = 300.0;
        double d6 = 775.0;
        int n6 = 6;
        double d7 = 70.0;
        double d8 = 2.6;
        double d9 = 0.93;
        System2D system2D = new System2D();
        int n7 = 4;
        int n8 = 1;
        ShowPainters showPainters = new ShowPainters(layeredPainter, new int[]{n7, n8});
        BufferedImage bufferedImage2 = BatteryResistorCircuitResources.loadBufferedImage("ron/particle-green-med.png");
        ImagePainter imagePainter = new ImagePainter(bufferedImage2);
        Resistance resistance = new Resistance(d5, d6, n6, wirePatch, d7, d8, d9, imagePainter, n7, n8, layeredPainter, showPainters, system2D);
        double d10 = 15.0;
        double d11 = 10.0;
        PatchRegion patchRegion = new PatchRegion(d5 - d10, d6 + d10, wirePatch);
        PatchRegion patchRegion2 = new PatchRegion(d5 - d11, d6 + d11, wirePatch);
        SimplePatch simplePatch = new SimplePatch(wirePatch2);
        CompositePropagator1d compositePropagator1d2 = new CompositePropagator1d();
        RangedPropagator rangedPropagator = new RangedPropagator();
        double d12 = 50.0;
        double d13 = d5 - d12;
        double d14 = d6 + d12;
        PatchRegion patchRegion3 = new PatchRegion(0.0, d13, wirePatch);
        PatchRegion patchRegion4 = new PatchRegion(d14, wirePatch.getLength(), wirePatch);
        double d15 = 35.0;
        SmoothBatt smoothBatt = new SmoothBatt(patchRegion3, patchRegion4, wireSystem, d15, 18.0);
        rangedPropagator.addPropagator(simplePatch, smoothBatt);
        rangedPropagator.addPropagator(simplePatch, new ResetElectron());
        compositePropagator1d2.addPropagator(rangedPropagator);
        compositePropagator1d2.addPropagator(new Crash());
        compositePropagator1d.addPropagator(compositePropagator1d2);
        BatteryForcePropagator batteryForcePropagator = new BatteryForcePropagator(0.0, 10.0 * d2);
        batteryForcePropagator.addForce(coulombForce);
        batteryForcePropagator.addForce(new AdjacentPatchCoulombForce(coulombForceParameters, wireSystem, wirePatch2, wirePatch));
        batteryForcePropagator.addForce(new AdjacentPatchCoulombForce2(coulombForceParameters, wireSystem, wirePatch2, wirePatch));
        batteryForcePropagator.addForce(new Friction1d(0.9999999));
        ResetScatterability resetScatterability = new ResetScatterability(wireSystem);
        AndRegion andRegion = new AndRegion();
        andRegion.addRegion(simplePatch);
        andRegion.addRegion(patchRegion2);
        double d16 = 1.4;
        Accel accel = new Accel(2.0, d2 * 15.0, d16);
        rangedPropagator.addPropagator(patchRegion, accel);
        rangedPropagator.addInverse(andRegion, batteryForcePropagator);
        compositePropagator1d.addPropagator(new DualJunction(wirePatch, wirePatch2));
        compositePropagator1d.addPropagator(new DualJunction(wirePatch2, wirePatch));
        BufferedImage bufferedImage3 = BatteryResistorCircuitResources.loadBufferedImage("ron/particle-blue-sml.gif");
        ImagePainter imagePainter2 = new ImagePainter(bufferedImage3);
        BufferedImage bufferedImage4 = BatteryResistorCircuitResources.loadBufferedImage("ron/AA-battery-555.png");
        bufferedImage4 = BufferedImageUtils.flipX(bufferedImage4);
        int n9 = (int)doublePoint4.getX() + 59;
        int n10 = (int)doublePoint4.getY() - bufferedImage4.getHeight() / 2 + 3;
        BufferedImagePainter bufferedImagePainter = new BufferedImagePainter(bufferedImage4, n9, n10);
        int n11 = 10;
        BufferedImage bufferedImage5 = BufferedImageUtils.flipX(bufferedImage4);
        BufferedImagePainter bufferedImagePainter2 = new BufferedImagePainter(bufferedImage5, (int)doublePoint4.getX() + 59, (int)doublePoint4.getY() - bufferedImage5.getHeight() / 2 + 3);
        BufferedImagePainter bufferedImagePainter3 = new BufferedImagePainter(BufferedImageUtils.scaleAlpha(bufferedImage4, 0.5), (int)doublePoint4.getX() + 59, (int)doublePoint4.getY() - bufferedImage4.getHeight() / 2 + 3);
        BufferedImagePainter bufferedImagePainter4 = new BufferedImagePainter(BufferedImageUtils.scaleAlpha(bufferedImage5, 0.5), (int)doublePoint4.getX() + 59, (int)doublePoint4.getY() - bufferedImage4.getHeight() / 2 + 3);
        BatteryPainter batteryPainter = new BatteryPainter(bufferedImagePainter, bufferedImagePainter2, bufferedImagePainter3, bufferedImagePainter4);
        BatteryDirectionChanger batteryDirectionChanger = new BatteryDirectionChanger(batteryPainter);
        layeredPainter.addPainter(batteryPainter, n11);
        int n12 = 25;
        int n13 = 390;
        int n14 = 50;
        double d17 = d2 * 4.0;
        BufferedImage bufferedImage6 = BatteryResistorCircuitResources.loadBufferedImage("components/gauges/vdo_samp_srr_edit3.gif");
        int n15 = bufferedImage6.getWidth() / 2;
        int n16 = bufferedImage6.getHeight() / 2 + 38;
        int n17 = bufferedImage6.getWidth() / 2 - 30;
        ImageGauge imageGauge = new ImageGauge(bufferedImage6, n12, n13, n15, n16, n17);
        layeredPainter.addPainter(imageGauge);
        AndRegion andRegion2 = new AndRegion();
        andRegion2.addRegion(new SimplePatch(wirePatch));
        andRegion2.addRegion(new SimplePatch(wirePatch2));
        AverageCurrent averageCurrent = new AverageCurrent(imageGauge, 100, andRegion2);
        GaugeScaling gaugeScaling = new GaugeScaling();
        gaugeScaling.add(new Scaling(imageGauge, BatteryResistorCircuitStrings.get("Ohm1dModule.Low"), -d17 / 4.0, d17 / 4.0), false);
        Scaling scaling = new Scaling(imageGauge, BatteryResistorCircuitStrings.get("Ohm1dModule.Medium"), -d17 / 2.0, d17 / 2.0);
        gaugeScaling.add(scaling, true);
        gaugeScaling.add(new Scaling(imageGauge, BatteryResistorCircuitStrings.get("Ohm1dModule.High"), -d17, d17), false);
        gaugeScaling.setBorder(BorderFactory.createTitledBorder(BatteryResistorCircuitStrings.get("Ohm1dModule.AmmeterScaleBorder")));
        scaling.actionPerformed(null);
        int n18 = 3;
        ShowPainters showPainters2 = new ShowPainters(layeredPainter, new int[]{n18, n18 - 1});
        resistance.layoutCores();
        double d18 = Double.MAX_VALUE;
        DoublePoint doublePoint9 = new DoublePoint(1.0, 2.0);
        double d19 = 0.9;
        Random random = new Random();
        DefaultOscillateFactory defaultOscillateFactory = new DefaultOscillateFactory(random, d19, d9, d8, d18, doublePoint9);
        double d20 = 2000.0;
        double d21 = 18.0;
        DefaultCollisionEvent defaultCollisionEvent = new DefaultCollisionEvent(d21, d20, defaultOscillateFactory);
        system2D.addLaw(defaultCollisionEvent);
        Collider collider = new Collider(wireSystem, defaultCollisionEvent, wirePatch);
        int n19 = (int)(circuit.getLength() / (double)n14);
        int n20 = 0;
        for (int i = 0; i < n14; ++i) {
            object2 = new Electron(compositePropagator1d, wirePatch, defaultCollisionEvent);
            double d22 = n19 * i;
            boolean bl = true;
            if (d22 > d5 && d22 < d6 && n20++ % 2 == 0) {
                bl = false;
            }
            if (!bl) continue;
            ((Electron)object2).setVelocity(0.0);
            wireSystem.add((WireParticle)object2);
            ((WireParticle)object2).setWirePatch(circuit.getPatch(d22));
            ((WireParticle)object2).setPosition(circuit.getLocalPosition(d22, circuit.getPatch(d22)));
            object = new WireParticlePainter((WireParticle)object2, imagePainter2);
            int n21 = random.nextInt(2);
            layeredPainter.addPainter((Painter)object, n18 - n21);
            averageCurrent.addParticle((WireParticle)object2);
            showPainters2.add((Painter)object);
        }
        system2D.addLaw(wireSystem);
        system2D.addLaw(collider);
        system2D.addLaw(new ParticleLaw());
        system2D.addLaw(averageCurrent);
        system2D.addLaw(new Repaint(painterPanel));
        painterPanel.setBackground(new Color(235, 230, 240));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)painterPanel, "Center");
        object2 = new JFrame(BatteryResistorCircuitStrings.get("Ohm1dModule.ControlsTitle"));
        ((Window)object2).setLocation(BASE_FRAME_WIDTH, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BatteryResistorCircuitStrings.get("Ohm1dModule.ControlPanelBorder")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        object = new JCheckBox(BatteryResistorCircuitStrings.get("Ohm1dModule.ShowCoresCheckbox"), true);
        ((AbstractButton)object).addActionListener(new ShowPainterListener((JCheckBox)object, showPainters));
        jPanel3.add((Component)object);
        JCheckBox jCheckBox = new JCheckBox(BatteryResistorCircuitStrings.get("Ohm1dModule.ShowElectronsCheckbox"), true);
        jCheckBox.addActionListener(new ShowPainterListener(jCheckBox, showPainters2));
        JCheckBox jCheckBox2 = new JCheckBox(BatteryResistorCircuitStrings.get("Ohm1dModule.ShowVoltageCalcCheckbox"), false);
        int n22 = 100;
        CompositePainter compositePainter = new CompositePainter();
        ShowPainters showPainters3 = new ShowPainters(layeredPainter, n22);
        showPainters3.add(compositePainter);
        showPainters3.setShowPainters(jCheckBox2.isSelected());
        jCheckBox2.addActionListener(new ShowPainterListener(jCheckBox2, showPainters3));
        jPanel3.add(jCheckBox2);
        JCheckBox jCheckBox3 = new JCheckBox(BatteryResistorCircuitStrings.get("Ohm1dModule.ShowInsideBatteryCheckbox"), false);
        ShowInsideBattery showInsideBattery = new ShowInsideBattery(jCheckBox3, batteryPainter);
        jCheckBox3.addActionListener(showInsideBattery);
        jPanel3.add(jCheckBox3);
        double d23 = -12.0;
        double d24 = Math.abs(d23 * 2.0);
        double d25 = 3.0;
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(2);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(2);
        BufferedImage bufferedImage7 = BatteryResistorCircuitResources.loadBufferedImage("ron/AA-battery-100.gif");
        VoltageSlider voltageSlider = new VoltageSlider(new Transform(0.0, 100.0, d23, d24), BatteryResistorCircuitStrings.get("Ohm1dModule.VoltageSliderName"), bufferedImage7, d25, decimalFormat, BatteryResistorCircuitStrings.get("Ohm1dModule.VoltageSliderUnits"));
        voltageSlider.addVoltageListener(smoothBatt);
        voltageSlider.addVoltageListener(batteryDirectionChanger);
        voltageSlider.addVoltageListener(averageCurrent);
        voltageSlider.addVoltageListener(accel);
        voltageSlider.addVoltageListener(filament);
        voltageSlider.addVoltageListener(batteryForcePropagator);
        voltageSlider.addVoltageListener(resetScatterability);
        BufferedImage bufferedImage8 = BatteryResistorCircuitResources.loadBufferedImage("ron/CoreCountImage.gif");
        CoreCountSlider coreCountSlider = new CoreCountSlider(3, n4, 6, BatteryResistorCircuitStrings.get("Ohm1dModule.CoreCountSliderName"), bufferedImage8, BatteryResistorCircuitStrings.get("Ohm1dModule.CoreCountSliderUnits"));
        coreCountSlider.addIntListener(resistance);
        coreCountSlider.addIntListener(averageCurrent);
        coreCountSlider.addIntListener(filament);
        coreCountSlider.addIntListener(smoothBatt);
        coreCountSlider.fireChange();
        JPanel jPanel4 = new JPanel();
        BufferedImage bufferedImage9 = BatteryResistorCircuitResources.loadBufferedImage("icons/Play16.gif");
        BufferedImage bufferedImage10 = BatteryResistorCircuitResources.loadBufferedImage("icons/Pause16.gif");
        ImageIcon imageIcon = new ImageIcon(bufferedImage9);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage10);
        JButton jButton = new JButton(BatteryResistorCircuitStrings.get("Ohm1dModule.PlayButton"), imageIcon);
        JButton jButton2 = new JButton(BatteryResistorCircuitStrings.get("Ohm1dModule.PauseButton"), imageIcon2);
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jButton.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(voltageSlider, gridBagConstraints);
        jPanel2.add(voltageSlider);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(coreCountSlider, gridBagConstraints);
        jPanel2.add(coreCountSlider);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel2.add(jPanel4);
        BasicStroke basicStroke3 = new BasicStroke(11.2f);
        double d26 = 25.0;
        DoublePoint doublePoint10 = doublePoint.add(new DoublePoint(-d26, -d26));
        DoublePoint doublePoint11 = doublePoint4.add(new DoublePoint(d26, d26));
        DoublePoint doublePoint12 = doublePoint11.subtract(doublePoint10);
        OvalPainter ovalPainter = new OvalPainter(Color.blue, basicStroke3, (int)doublePoint10.getX(), (int)doublePoint10.getY(), (int)doublePoint12.getX(), (int)doublePoint12.getY());
        compositePainter.addPainter(ovalPainter);
        DoublePoint doublePoint13 = doublePoint2.add(new DoublePoint(-d26, -d26));
        DoublePoint doublePoint14 = doublePoint3.add(new DoublePoint(d26, d26));
        DoublePoint doublePoint15 = doublePoint14.subtract(doublePoint13);
        OvalPainter ovalPainter2 = new OvalPainter(Color.blue, basicStroke3, (int)doublePoint13.getX(), (int)doublePoint13.getY(), (int)doublePoint15.getX(), (int)doublePoint15.getY());
        compositePainter.addPainter(ovalPainter2);
        PhetFont phetFont2 = new PhetFont(19);
        Color color2 = Color.black;
        int n23 = 150;
        int n24 = 170;
        int n25 = 20;
        TextPainter textPainter = new TextPainter("3 " + BatteryResistorCircuitStrings.get("VoltCount.Electrons"), n23, n24, phetFont2, color2);
        TextPainter textPainter2 = new TextPainter("-5 " + BatteryResistorCircuitStrings.get("VoltCount.Electrons"), n23, n24 + n25, phetFont2, color2);
        TextPainter textPainter3 = new TextPainter("= -2 " + BatteryResistorCircuitStrings.get("VoltCount.Volts"), n23, n24 + n25 * 2, phetFont2, color2);
        VoltCount voltCount = new VoltCount(textPainter, smoothBatt, textPainter3, textPainter2);
        voltCount.iterate(0.0, null);
        system2D.addLaw(voltCount);
        compositePainter.addPainter(textPainter);
        compositePainter.addPainter(textPainter2);
        compositePainter.addPainter(textPainter3);
        BasicStroke basicStroke4 = new BasicStroke(2.3f);
        DefaultVectorPainter defaultVectorPainter = new DefaultVectorPainter(Color.blue, basicStroke4);
        DoublePoint doublePoint16 = new DoublePoint(n23 + 110, n24 - 5);
        DoublePoint doublePoint17 = new DoublePoint(n23 - 4, n24 + n25 - 7);
        DoublePoint doublePoint18 = new DoublePoint(doublePoint11.getX(), (doublePoint11.getY() + doublePoint10.getY()) / 2.0);
        DoublePoint doublePoint19 = doublePoint18.subtract(doublePoint17);
        VectorPainterAdapter vectorPainterAdapter = new VectorPainterAdapter(defaultVectorPainter, (int)doublePoint17.getX(), (int)doublePoint17.getY(), (int)doublePoint19.getX() + 15, (int)doublePoint19.getY());
        DoublePoint doublePoint20 = new DoublePoint(doublePoint13.getX() - 25.0, (doublePoint11.getY() + doublePoint10.getY()) / 2.0);
        DoublePoint doublePoint21 = doublePoint20.subtract(doublePoint16);
        VectorPainterAdapter vectorPainterAdapter2 = new VectorPainterAdapter(defaultVectorPainter, (int)doublePoint16.getX(), (int)doublePoint16.getY(), (int)doublePoint21.getX() + 15, (int)doublePoint21.getY());
        compositePainter.addPainter(vectorPainterAdapter);
        compositePainter.addPainter(vectorPainterAdapter2);
        BufferedImage bufferedImage11 = BatteryResistorCircuitResources.loadBufferedImage("pushers/PushLeft.gif");
        BufferedImage bufferedImage12 = BatteryResistorCircuitResources.loadBufferedImage("pushers/PushRight.gif");
        Point point = new Point(-bufferedImage11.getWidth() / 2 - 20, -bufferedImage11.getHeight() / 2 + 4);
        Point point2 = new Point(-bufferedImage11.getWidth() / 2 + 18, -bufferedImage11.getHeight() / 2 + 4);
        PatchRegion patchRegion5 = new PatchRegion(20.0, wirePatch2.getLength() - 20.0, wirePatch2);
        AngelPaint angelPaint = new AngelPaint(patchRegion5, bufferedImage11, bufferedImage12, wireSystem, wirePatch2, point, point2, jCheckBox3);
        layeredPainter.addPainter(angelPaint, 2);
        BufferedImage bufferedImage13 = BatteryResistorCircuitResources.loadBufferedImage("wheels/Pinwheel2.gif");
        Point point3 = new Point(5, 140);
        double d27 = 0.02;
        Turnstile turnstile = new Turnstile(point3, bufferedImage13, d27);
        layeredPainter.addPainter(turnstile, n18 - 1);
        system2D.addLaw(turnstile);
        averageCurrent.addCurrentListener(turnstile);
        BufferedImage bufferedImage14 = BatteryResistorCircuitResources.loadBufferedImage("components/cable-srr3.gif");
        BufferedImagePainter bufferedImagePainter5 = new BufferedImagePainter(bufferedImage14, point3.x + bufferedImage13.getWidth() / 2 - bufferedImage14.getWidth() / 2, point3.y + bufferedImage13.getHeight() / 2);
        layeredPainter.addPainter(bufferedImagePainter5, -1);
        Font font = phetFont2.deriveFont(0, 44.2f);
        Point point4 = new Point(n9 + 30, n10 + 45);
        Point point5 = new Point(n9 + bufferedImage4.getWidth() - 170, point4.y);
        VoltageOnBattery voltageOnBattery = new VoltageOnBattery(point4, point5, font, BatteryResistorCircuitStrings.get("VoltageOnBattery.DefaultText"));
        voltageSlider.addVoltageListener(voltageOnBattery);
        layeredPainter.addPainter(voltageOnBattery, 100);
        voltageSlider.addVoltageListener(angelPaint);
        voltageSlider.fireChange();
        final SystemRunner systemRunner = new SystemRunner(system2D, 0.2);
        new MediaHandler(jButton, jButton2, systemRunner);
        this.clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                systemRunner.step();
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel2);
        jPanel.add((Component)jPanel5, "East");
        jPanel2.setPreferredSize(new Dimension(200, jPanel2.getPreferredSize().height + 20));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    class MediaHandler {
        JButton playButton;
        JButton pauseButton;
        SystemRunner sr;

        public MediaHandler(JButton jButton, JButton jButton2, SystemRunner systemRunner) {
            this.playButton = jButton;
            this.sr = systemRunner;
            this.pauseButton = jButton2;
            jButton.addActionListener(new PlayListener());
            jButton2.addActionListener(new PauseListener());
        }

        class PauseListener
        implements ActionListener {
            PauseListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MediaHandler.this.playButton.setEnabled(true);
                MediaHandler.this.pauseButton.setEnabled(false);
                BatteryResistorCircuitSimulationPanel.this.clock.pause();
            }
        }

        class PlayListener
        implements ActionListener {
            PlayListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MediaHandler.this.playButton.setEnabled(false);
                MediaHandler.this.pauseButton.setEnabled(true);
                BatteryResistorCircuitSimulationPanel.this.clock.start();
            }
        }
    }
}

