/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit;

import edu.colorado.phet.batteryresistorcircuit.common.paint.LayeredPainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.SwitchablePainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.particle.ParticlePainter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.particle.ParticlePainterAdapter;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Law;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Particle;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountListener;
import edu.colorado.phet.batteryresistorcircuit.gui.ShowPainters;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Core;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Oscillate;
import java.util.Vector;

public class Resistance
implements Law,
CoreCountListener {
    double start;
    double end;
    int numCores;
    WirePatch wp;
    double amplitude;
    double freq;
    double decay;
    ParticlePainter dp;
    int coreLevelTop;
    int coreLevelBottom;
    LayeredPainter cp;
    ShowPainters showCores;
    System2D sys;
    Vector painteric = new Vector();
    Vector systemic = new Vector();

    public Resistance(double d, double d2, int n, WirePatch wirePatch, double d3, double d4, double d5, ParticlePainter particlePainter, int n2, int n3, LayeredPainter layeredPainter, ShowPainters showPainters, System2D system2D) {
        this.sys = system2D;
        this.showCores = showPainters;
        this.cp = layeredPainter;
        this.coreLevelTop = n2;
        this.coreLevelBottom = n3;
        this.dp = particlePainter;
        this.decay = d5;
        this.freq = d4;
        this.amplitude = d3;
        this.wp = wirePatch;
        this.start = d;
        this.end = d2;
        this.numCores = n;
    }

    public void iterate(double d, System2D system2D) {
        this.removeCores();
        this.painteric = new Vector();
        this.systemic = new Vector();
        this.layoutCores();
        system2D.remove(this);
    }

    public void coreCountChanged(int n) {
        if (n != this.numCores) {
            this.numCores = n;
            this.sys.addLaw(this);
        }
    }

    public void layoutCores() {
        double d = this.getCoreDX();
        for (int i = 0; i < this.numCores; ++i) {
            double d2 = this.start + d * (double)i + 15.0;
            if (this.numCores == 1) {
                d2 = (this.end - this.start) / 2.0 + this.start;
            }
            DoublePoint doublePoint = this.wp.getPosition(d2);
            DoublePoint doublePoint2 = new DoublePoint(1.0, 0.0);
            Oscillate oscillate = new Oscillate(doublePoint, this.amplitude, this.freq, this.decay, doublePoint2);
            oscillate.setAmplitude(0.0);
            Core core = new Core(doublePoint, d2);
            core.setCharge(0.0);
            core.setPropagator(oscillate);
            core.setPosition(doublePoint);
            ParticlePainterAdapter particlePainterAdapter = new ParticlePainterAdapter(this.dp, core);
            SwitchablePainter switchablePainter = new SwitchablePainter(particlePainterAdapter);
            this.painteric.add(switchablePainter);
            if (i % 2 == 0) {
                this.cp.addPainter(switchablePainter, this.coreLevelTop);
            } else {
                this.cp.addPainter(switchablePainter, this.coreLevelBottom);
            }
            this.showCores.add(switchablePainter);
            this.sys.addParticle(core);
            this.systemic.add(core);
        }
    }

    public void removeCores() {
        Object object;
        int n;
        for (n = 0; n < this.painteric.size(); ++n) {
            object = (Painter)this.painteric.get(n);
            this.cp.removePainter((Painter)object, this.coreLevelTop);
            this.cp.removePainter((Painter)object, this.coreLevelBottom);
            this.showCores.remove((Painter)object);
        }
        for (n = 0; n < this.systemic.size(); ++n) {
            object = (Particle)this.systemic.get(n);
            this.sys.remove((Particle)object);
        }
    }

    public double getCoreDX() {
        if (this.numCores <= 1) {
            return 0.0;
        }
        double d = this.end - this.start;
        double d2 = d / (double)(this.numCores - 1);
        return d2;
    }
}

