/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.collisions;

import edu.colorado.phet.batteryresistorcircuit.Electron;
import edu.colorado.phet.batteryresistorcircuit.collisions.CollisionEvent;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Law;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Particle;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Core;

public class Collider
implements Law {
    WireSystem ws;
    CollisionEvent ce;
    WirePatch patch;

    public Collider(WireSystem wireSystem, CollisionEvent collisionEvent, WirePatch wirePatch) {
        this.patch = wirePatch;
        this.ws = wireSystem;
        this.ce = collisionEvent;
    }

    public void iterate(double d, System2D system2D) {
        for (int i = 0; i < system2D.numParticles(); ++i) {
            Particle particle = system2D.particleAt(i);
            if (!(particle instanceof Core)) continue;
            Core core = (Core)particle;
            for (int j = 0; j < this.ws.numParticles(); ++j) {
                Electron electron = (Electron)this.ws.particleAt(j);
                if (electron.getWirePatch() != this.patch) continue;
                this.ce.collide(core, electron);
            }
        }
    }
}

