/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.common.paint.gauges;

import edu.colorado.phet.batteryresistorcircuit.common.paint.gauges.IGauge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageGauge
implements IGauge {
    double min;
    double max;
    double amount;
    double length;
    BufferedImage image;
    int x;
    int y;
    int lineX;
    int lineY;

    public ImageGauge(BufferedImage bufferedImage, int n, int n2, int n3, int n4, double d) {
        this(-1.0, 1.0, 0.0, d, bufferedImage, n, n2, n3, n4);
    }

    public ImageGauge(double d, double d2, double d3, double d4, BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        this.min = d;
        this.max = d2;
        this.amount = d3;
        this.length = d4;
        this.image = bufferedImage;
        this.x = n;
        this.y = n2;
        this.lineX = n3;
        this.lineY = n4;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public void setValue(double d) {
        this.amount = d;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.drawRenderedImage(this.image, AffineTransform.getTranslateInstance(this.x, this.y));
        double d = this.amount / (this.max - this.min) * Math.PI;
        double d2 = this.length * Math.sin(d);
        double d3 = this.length * Math.cos(d);
        int n = this.x + (int)d2 + this.lineX;
        int n2 = this.y - (int)d3 + this.lineY;
        graphics2D.setColor(new Color(240, 20, 120));
        graphics2D.setStroke(new BasicStroke(5.0f));
        int n3 = 8;
        int n4 = 8;
        graphics2D.drawLine(this.x + this.lineX, this.y + this.lineY, n, n2 - n4 / 2);
        graphics2D.setColor(Color.blue);
        graphics2D.fillOval(this.x + this.lineX - n3 / 2, this.y + this.lineY - n4 / 2, n3, n4);
    }
}

