/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Force1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces.CoulombForceParameters;

public class CoulombForce
implements Force1d {
    WireSystem sys;
    CoulombForceParameters params;

    public CoulombForce(CoulombForceParameters coulombForceParameters, WireSystem wireSystem) {
        this.sys = wireSystem;
        this.params = coulombForceParameters;
    }

    public double getForce(WireParticle wireParticle) {
        double d = 0.0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            WireParticle wireParticle2 = this.sys.particleAt(i);
            if (wireParticle2 == wireParticle || wireParticle2.getWirePatch() != wireParticle.getWirePatch()) continue;
            d += this.params.getForce(wireParticle2, wireParticle);
        }
        return d;
    }
}

