/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Propagator1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;

public class Accel
implements Propagator1d,
VoltageListener {
    double g;
    double vmax;
    double accelScale;

    public Accel(double d, double d2, double d3) {
        this.vmax = d2;
        this.g = d;
        this.accelScale = d3;
    }

    public void valueChanged(double d) {
        this.g = -d * this.accelScale;
    }

    public void propagate(WireParticle wireParticle, double d) {
        double d2 = wireParticle.getVelocity() + this.g * d;
        wireParticle.setVelocity(d2);
        if (d2 < 0.0 && this.g > 0.0) {
            wireParticle.setVelocity(0.0);
        } else if (d2 > 0.0 && this.g < 0.0) {
            wireParticle.setVelocity(0.0);
        }
        d2 = Math.min(d2, this.vmax);
        double d3 = wireParticle.getPosition();
        double d4 = d3 + wireParticle.getVelocity() * d;
        wireParticle.setPosition(d4);
    }
}

