/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Propagator1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountListener;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import edu.colorado.phet.batteryresistorcircuit.volt.WireRegion;

public class Batt
implements Propagator1d,
CoreCountListener,
VoltageListener {
    WireRegion plus;
    WireRegion minus;
    WireSystem sys;
    double v;
    double desiredVolts;

    public void valueChanged(double d) {
        this.desiredVolts = d;
    }

    public Batt(WireRegion wireRegion, WireRegion wireRegion2, WireSystem wireSystem, double d, double d2) {
        this.desiredVolts = d2;
        this.v = d;
        this.plus = wireRegion;
        this.minus = wireRegion2;
        this.sys = wireSystem;
    }

    public int countLeft() {
        int n = 0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            if (!this.plus.contains(this.sys.particleAt(i))) continue;
            ++n;
        }
        return n;
    }

    public int countRight() {
        int n = 0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            if (!this.minus.contains(this.sys.particleAt(i))) continue;
            ++n;
        }
        return n;
    }

    public void propagate(WireParticle wireParticle, double d) {
        int n = this.countLeft();
        int n2 = this.countRight();
        double d2 = n2 - n;
        if (d2 < this.desiredVolts) {
            wireParticle.setVelocity(-this.v);
        } else if (d2 > this.desiredVolts) {
            wireParticle.setVelocity(this.v);
        } else {
            return;
        }
        double d3 = wireParticle.getPosition();
        double d4 = d3 + wireParticle.getVelocity() * d;
        wireParticle.setPosition(d4);
    }

    public void coreCountChanged(int n) {
    }
}

