/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.volt.PowerListener;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BlackbodyScale
implements Painter,
PowerListener {
    BufferedImage spectrum;
    BufferedImage arrow;
    AffineTransform at;
    int y;
    int x0;
    AffineTransform arrowTransform = new AffineTransform();

    public BlackbodyScale(BufferedImage bufferedImage, int n, int n2, BufferedImage bufferedImage2) {
        this.x0 = n;
        this.spectrum = bufferedImage;
        this.arrow = bufferedImage2;
        this.at = AffineTransform.getTranslateInstance(n, n2);
        this.y = bufferedImage.getHeight() + n2;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.drawRenderedImage(this.spectrum, this.at);
        graphics2D.drawRenderedImage(this.arrow, this.arrowTransform);
    }

    public void powerChanged(double d) {
        double d2 = (double)(-this.arrow.getWidth() / 2 + this.x0) + d * (double)this.spectrum.getWidth();
        this.arrowTransform = AffineTransform.getTranslateInstance(d2, this.y);
    }
}

