/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.paint.WirePatchPainter;
import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountListener;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import edu.colorado.phet.batteryresistorcircuit.volt.ColorMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class Filament
implements Painter,
CoreCountListener,
VoltageListener {
    BasicStroke stroke;
    WirePatch patch;
    WirePatchPainter painter;
    double v = 1.0;
    double r = 1.0;
    double powMax;
    ColorMap cm;

    public Filament(BasicStroke basicStroke, WirePatch wirePatch, double d, double d2, ColorMap colorMap) {
        this.cm = colorMap;
        this.stroke = basicStroke;
        this.patch = wirePatch;
        this.powMax = d * d / d2;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.cm.isChanging()) {
            this.fixPainter();
        }
        this.painter.paint(graphics2D);
    }

    public void coreCountChanged(int n) {
        this.r = n;
        this.fixPainter();
    }

    private void fixPainter() {
        double d = this.v * this.v / this.r;
        Color color = this.powerToColor(d);
        this.painter = new WirePatchPainter(this.stroke, color, this.patch);
    }

    private Color powerToColor(double d) {
        double d2 = d / this.powMax;
        return this.cm.toColor(d2);
    }

    public void valueChanged(double d) {
        this.v = d;
        this.fixPainter();
    }
}

