/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Propagator1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.volt.WireRegion;
import java.util.Vector;

public class RangedPropagator
implements Propagator1d {
    Vector v = new Vector();
    Vector inv = new Vector();

    public void addInverse(WireRegion wireRegion, Propagator1d propagator1d) {
        this.inv.add(new RangeProp(wireRegion, propagator1d));
    }

    public void addPropagator(WireRegion wireRegion, Propagator1d propagator1d) {
        this.v.add(new RangeProp(wireRegion, propagator1d));
    }

    public void propagate(WireParticle wireParticle, double d) {
        RangeProp rangeProp;
        int n;
        for (n = 0; n < this.v.size(); ++n) {
            rangeProp = (RangeProp)this.v.get(n);
            if (!rangeProp.wr.contains(wireParticle)) continue;
            rangeProp.prop.propagate(wireParticle, d);
        }
        for (n = 0; n < this.inv.size(); ++n) {
            rangeProp = (RangeProp)this.inv.get(n);
            if (rangeProp.wr.contains(wireParticle)) continue;
            rangeProp.prop.propagate(wireParticle, d);
        }
    }

    private static class RangeProp {
        WireRegion wr;
        Propagator1d prop;

        public RangeProp(WireRegion wireRegion, Propagator1d propagator1d) {
            this.wr = wireRegion;
            this.prop = propagator1d;
        }
    }
}

