/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.volt.ColorMap;
import edu.colorado.phet.batteryresistorcircuit.volt.PowerListener;
import edu.colorado.phet.common.phetcommon.math.DoubleSeries;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class Spectrum
implements ColorMap {
    BufferedImage bi;
    DoubleSeries series;
    int numSame = 0;
    double lastAverage;
    Vector listeners = new Vector();

    public Spectrum(BufferedImage bufferedImage, int n) {
        this.series = new DoubleSeries(n);
        this.bi = bufferedImage;
    }

    public Color toColor(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.series.add(d);
        d = this.series.average();
        int n = (int)((double)this.bi.getWidth() * d);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.bi.getWidth()) {
            n = this.bi.getWidth() - 1;
        }
        int[] nArray = new int[4];
        nArray = this.bi.getRaster().getPixel(n, 0, nArray);
        double d2 = d;
        this.numSame = this.lastAverage == d2 ? ++this.numSame : 0;
        this.lastAverage = d2;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PowerListener)this.listeners.get(i)).powerChanged(d2);
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public boolean isChanging() {
        return (double)this.numSame < this.series.getSampleCount();
    }

    public void addPowerListener(PowerListener powerListener) {
        this.listeners.add(powerListener);
    }
}

