/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Law;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.volt.CurrentListener;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class Turnstile
implements Painter,
Law,
CurrentListener {
    BufferedImage image;
    double angle;
    double angularSpeed;
    int width;
    int height;
    AffineTransform centerTrf;
    double angVelScale;

    public Turnstile(Point point, BufferedImage bufferedImage, double d) {
        this.angVelScale = d;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.centerTrf = AffineTransform.getTranslateInstance(point.x, point.y);
        this.image = bufferedImage;
        this.angularSpeed = 0.31;
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.angle, this.width / 2, this.height / 2);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.concatenate(this.centerTrf);
        affineTransform2.concatenate(affineTransform);
        graphics2D.drawRenderedImage(this.image, affineTransform2);
    }

    public void iterate(double d, System2D system2D) {
        this.angle = this.angularSpeed * d + this.angle;
    }

    public void currentChanged(double d) {
        this.angularSpeed = d * this.angVelScale;
    }
}

