/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.BatteryResistorCircuitStrings;
import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.paint.TextPainter;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.DecimalFormat;

public class VoltageOnBattery
implements Painter,
VoltageListener {
    TextPainter tp;
    DecimalFormat nf = new DecimalFormat();
    Point pos;
    Point neg;

    public VoltageOnBattery(Point point, Point point2, Font font, String string) {
        this.pos = point;
        this.neg = point2;
        Color color = new Color(100, 100, 250);
        this.tp = new TextPainter(string, point.x, point.y, font, color);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
    }

    public void paint(Graphics2D graphics2D) {
        this.tp.paint(graphics2D);
    }

    public void valueChanged(double d) {
        if (d < 0.0) {
            this.tp.setPosition(this.neg.x, this.neg.y);
        } else {
            this.tp.setPosition(this.pos.x, this.pos.y);
        }
        d = Math.abs(d);
        String string = this.nf.format(d);
        this.tp.setText(string + " " + BatteryResistorCircuitStrings.get("VoltageOnBattery.VoltsAbbreviation"));
    }
}

