/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.util;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import java.util.ArrayList;
import java.util.List;

public class ScalarDataRecorder {
    private List dataRecord = new ArrayList();
    private double dataTotal;
    private double dataAverage;
    private double timeWindow = 5.0;
    private double timeSpanOfEntries;
    private Clock clock;

    public ScalarDataRecorder(Clock clock) {
        this.clock = clock;
    }

    public void clear() {
        this.dataRecord.removeAll(this.dataRecord);
    }

    public double getDataTotal() {
        return this.dataTotal;
    }

    public double getDataAverage() {
        return this.dataAverage;
    }

    public double getTimeWindow() {
        return this.timeWindow;
    }

    public synchronized void computeDataStatistics() {
        double d = this.clock.getSimulationTime();
        if (this.dataRecord.size() > 0) {
            double d2 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            while (this.dataRecord.size() > 0 && d - d2 > this.timeWindow) {
                this.dataRecord.remove(0);
                if (this.dataRecord.size() <= 0) continue;
                d2 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            }
        }
        this.dataTotal = 0.0;
        for (int i = 0; i < this.dataRecord.size(); ++i) {
            DataRecordEntry dataRecordEntry = (DataRecordEntry)this.dataRecord.get(i);
            this.dataTotal += dataRecordEntry.getValue();
        }
        this.dataAverage = 0.0;
        if (this.dataRecord.size() > 0) {
            double d3 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            double d4 = ((DataRecordEntry)this.dataRecord.get(this.dataRecord.size() - 1)).getTime();
            this.timeSpanOfEntries = d4 - d3;
            this.dataAverage = this.dataTotal / (double)this.dataRecord.size();
        }
    }

    public synchronized void addDataRecordEntry(double d) {
        DataRecordEntry dataRecordEntry = new DataRecordEntry(this.clock.getSimulationTime(), d);
        this.dataRecord.add(dataRecordEntry);
    }

    public void setTimeWindow(double d) {
        this.timeWindow = d;
    }

    private class DataRecordEntry {
        private double time;
        private double value;

        DataRecordEntry(double d, double d2) {
            this.time = d;
            this.value = d2;
        }

        public double getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }
    }
}

