/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.Box2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Box2DGraphic
extends CompositePhetGraphic
implements Box2D.ChangeListener {
    public static double s_thickness = 12.0;
    private static Stroke s_defaultStroke = new BasicStroke((float)s_thickness);
    private static Color s_openingColor;
    private Box2D box;
    private boolean graphicSelected;
    private int wallSpeedLimit = 3;
    private boolean leftWallHighlighted;
    private InternalBoxGraphic internalBoxGraphic;
    private Rectangle2D.Double mouseableArea = new Rectangle2D.Double();
    private Color wallColor = new Color(180, 180, 180);

    public Box2DGraphic(Component component, Box2D box2D, Color color) {
        super(component);
        this.box = box2D;
        box2D.addChangeListener(this);
        this.wallColor = color;
        this.internalBoxGraphic = new InternalBoxGraphic(component);
        this.setCursor(Cursor.getPredefinedCursor(11));
        this.addTranslationListener(new Translator());
    }

    public void setWallColor(Color color) {
        this.wallColor = color;
    }

    public boolean isGraphicSelected() {
        return this.graphicSelected;
    }

    public void fireMousePressed(MouseEvent mouseEvent) {
        this.graphicSelected = true;
        super.fireMousePressed(mouseEvent);
    }

    public void fireMouseReleased(MouseEvent mouseEvent) {
        this.graphicSelected = false;
        super.fireMouseReleased(mouseEvent);
    }

    public void fireMouseEntered(MouseEvent mouseEvent) {
        super.fireMouseEntered(mouseEvent);
        this.leftWallHighlighted = true;
        this.setBoundsDirty();
        this.repaint();
    }

    public void fireMouseExited(MouseEvent mouseEvent) {
        super.fireMouseExited(mouseEvent);
        this.leftWallHighlighted = false;
        this.setBoundsDirty();
        this.repaint();
    }

    protected Rectangle determineBounds() {
        return this.internalBoxGraphic.getBounds();
    }

    protected PhetGraphic getHandler(Point point) {
        if (this.getVisibilityFlag() && this.mouseableArea.contains(point)) {
            return this;
        }
        return null;
    }

    public void removeAllMouseInputListeners() {
        super.removeAllMouseInputListeners();
        this.internalBoxGraphic.showHandle(false);
    }

    public void paint(Graphics2D graphics2D) {
        this.internalBoxGraphic.paint(graphics2D);
    }

    public void boundsChanged(Box2D.ChangeEvent changeEvent) {
        Box2D box2D = changeEvent.getBox2D();
        if (box2D.isVolumeFixed()) {
            // empty if block
        }
    }

    public void isVolumeFixedChanged(Box2D.ChangeEvent changeEvent) {
        if (changeEvent.getBox2D().isVolumeFixed()) {
            this.setIgnoreMouse(true);
            this.internalBoxGraphic.showHandle(false);
        } else {
            this.setIgnoreMouse(false);
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.internalBoxGraphic.showHandle(true);
        }
    }

    private class InternalBoxGraphic
    extends PhetShapeGraphic
    implements SimpleObserver {
        private Rectangle2D.Double rect;
        private Rectangle openingRect;
        private BufferedImage wallHandle;
        private Point wallHandleLocation;
        private boolean isHandleEnabled;

        public InternalBoxGraphic(Component component) {
            super(component, null, s_defaultStroke, Box2DGraphic.this.wallColor);
            this.rect = new Rectangle2D.Double();
            this.openingRect = new Rectangle();
            this.isHandleEnabled = true;
            Box2DGraphic.this.box.addObserver(this);
            this.setShape(Box2DGraphic.this.mouseableArea);
            this.wallHandle = IdealGasResources.getImage("wall-handle.gif");
            this.update();
        }

        protected Rectangle determineBounds() {
            return Box2DGraphic.this.mouseableArea.getBounds();
        }

        public void update() {
            this.rect.setRect(Box2DGraphic.this.box.getMinX(), Box2DGraphic.this.box.getMinY(), Box2DGraphic.this.box.getMaxX() - Box2DGraphic.this.box.getMinX(), Box2DGraphic.this.box.getMaxY() - Box2DGraphic.this.box.getMinY());
            Box2DGraphic.this.mouseableArea.setRect(Box2DGraphic.this.box.getMinX() - s_thickness, Box2DGraphic.this.box.getMinY() - s_thickness / 2.0, s_thickness, Box2DGraphic.this.box.getMaxY() - Box2DGraphic.this.box.getMinY() + s_thickness);
            this.wallHandleLocation = new Point((int)(Box2DGraphic.this.box.getMinX() - (double)this.wallHandle.getWidth()), (int)(Box2DGraphic.this.box.getMinY() + Box2DGraphic.this.box.getHeight() + (double)this.wallHandle.getHeight()) / 2);
            Box2DGraphic.this.mouseableArea.add(new Rectangle(this.wallHandleLocation.x, this.wallHandleLocation.y, this.wallHandle.getWidth(), this.wallHandle.getHeight()));
            Point2D[] point2DArray = Box2DGraphic.this.box.getOpening();
            this.openingRect.setFrameFromDiagonal(point2DArray[0].getX(), point2DArray[0].getY(), point2DArray[1].getX(), point2DArray[1].getY() - (s_thickness - 1.0));
            super.setBoundsDirty();
            super.repaint();
        }

        public void paint(Graphics2D graphics2D) {
            this.saveGraphicsState(graphics2D);
            if (this.isHandleEnabled) {
                graphics2D.drawImage(this.wallHandle, this.wallHandleLocation.x, this.wallHandleLocation.y, this.wallHandle.getWidth(), this.wallHandle.getHeight(), null);
            }
            graphics2D.setStroke(s_defaultStroke);
            graphics2D.setColor(Box2DGraphic.this.wallColor);
            graphics2D.draw(this.rect);
            s_openingColor = Color.black;
            graphics2D.setColor(s_openingColor);
            graphics2D.fill(this.openingRect);
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.rect);
            if (Box2DGraphic.this.leftWallHighlighted) {
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor(Color.red);
                graphics2D.draw(Box2DGraphic.this.mouseableArea.getBounds());
            }
            this.restoreGraphicsState();
        }

        void showHandle(boolean bl) {
            this.isHandleEnabled = bl;
            this.setBoundsDirty();
            this.repaint();
        }
    }

    private class Translator
    implements TranslationListener {
        private Translator() {
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            if (!Box2DGraphic.this.box.isVolumeFixed()) {
                double d = translationEvent.getDx();
                d = Math.max((double)(-Box2DGraphic.this.wallSpeedLimit), Math.min(d, (double)Box2DGraphic.this.wallSpeedLimit));
                double d2 = Math.min(Math.max(Box2DGraphic.this.box.getMinX() + d, 50.0), Box2DGraphic.this.box.getMaxX() - Box2DGraphic.this.box.getMinimumWidth());
                Box2DGraphic.this.box.setBounds(d2, Box2DGraphic.this.box.getMinY(), Box2DGraphic.this.box.getMaxX(), Box2DGraphic.this.box.getMaxY());
                Box2DGraphic.this.internalBoxGraphic.update();
            }
        }
    }
}

