/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.aphidmaze;

import edu.colorado.phet.ladybugmotion2d.aphidmaze.Aphid;
import edu.colorado.phet.ladybugmotion2d.aphidmaze.BarrierSet;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel;
import edu.colorado.phet.scalacommon.Predef$;
import edu.colorado.phet.scalacommon.math.Vector2D;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AphidMazeModel
extends LadybugModel {
    private final BarrierSet maze = new BarrierSet();
    private final ArrayBuffer<Aphid> aphids = new ArrayBuffer();

    public BarrierSet maze() {
        return this.maze;
    }

    public ArrayBuffer<Aphid> aphids() {
        return this.aphids;
    }

    @Override
    public void stepInTime(double dt) {
        Vector2D prevPosition = this.ladybug().getPosition();
        super.stepInTime(dt);
        Vector2D newPosition = this.ladybug().getPosition();
        if (this.maze().crossedBarrier(prevPosition, newPosition)) {
            this.ladybug().setPosition(prevPosition);
            this.ladybug().setVelocity(new Vector2D());
            this.ladybug().setAcceleration(new Vector2D());
            this.resetMotion2DModel();
            this.setSamplePoint(Predef$.MODULE$.vector2DToPoint(prevPosition));
        }
        this.maze().update(this.ladybug());
        this.aphids().foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final AphidMazeModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Aphid aphid) {
                this.$outer.handleCollision(aphid);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleCollision(Aphid a) {
        if (this.ladybug().getEllipse().intersects(a.getBounds())) {
            this.eatAphid(a);
        }
    }

    public void eatAphid(Aphid a) {
    }

    public void setMazeDim(int dim) {
        this.maze().setDim(dim);
    }

    public AphidMazeModel() {
        this.aphids().$plus$eq((Object)new Aphid(0.0, 0.0));
        this.aphids().$plus$eq((Object)new Aphid(4.0, 3.0));
        this.maze().addListenerByName((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final AphidMazeModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.$outer.maze().getBounds().contains(Predef$.MODULE$.vector2DToPoint(this.$outer.ladybug().getPosition()))) {
                    this.$outer.ladybug().setPosition(0.5, 0.5);
                    this.$outer.setSamplePoint(Predef$.MODULE$.vector2DToPoint(this.$outer.ladybug().getPosition()));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

