/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.canvas;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.ladybugmotion2d.LadybugDefaults$;
import edu.colorado.phet.ladybugmotion2d.model.Bug;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public class BugNode
extends PNode {
    private final Bug bug;
    private final ModelViewTransform2D transform;
    private final BufferedImage bufferedImage;
    private final PImage pimage;

    public PImage pimage() {
        return this.pimage;
    }

    public void updateBug() {
        this.pimage().setTransform(new AffineTransform());
        Vector2D modelPosition = this.bug.getPosition();
        Point viewPosition = this.transform.modelToView(modelPosition.toImmutableVector2D());
        Vector2D dx = new Vector2D(this.pimage().getImage().getWidth(null), this.pimage().getImage().getHeight(null));
        double scale = this.transform.modelToViewDifferentialXDouble(this.bug.getRadius() * (double)4) / (double)this.bufferedImage.getWidth();
        this.pimage().translate((double)viewPosition.x - dx.x() / (double)2 * scale, (double)viewPosition.y - dx.y() / (double)2 * scale);
        this.pimage().scale(scale);
        this.pimage().rotateAboutPoint(this.bug.getAngleInvertY(), this.pimage().getFullBounds().getCenter2D().getX() - ((double)viewPosition.x - dx.x() / (double)2), this.pimage().getFullBounds().getCenter2D().getY() - ((double)viewPosition.y - dx.y() / (double)2));
    }

    public BugNode(Bug bug, ModelViewTransform2D transform, BufferedImage bufferedImage) {
        this.bug = bug;
        this.transform = transform;
        this.bufferedImage = bufferedImage;
        this.pimage = new PImage(BufferedImageUtils.multiScale(bufferedImage, LadybugDefaults$.MODULE$.LADYBUG_SCALE()));
        this.addChild(this.pimage());
        bug.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final BugNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateBug();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.updateBug();
        transform.addTransformListener(new TransformListener(this){
            private final BugNode $outer;

            public void transformChanged(ModelViewTransform2D mvt) {
                this.$outer.updateBug();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

