/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.canvas;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.ladybugmotion2d.LadybugDefaults$;
import edu.colorado.phet.ladybugmotion2d.canvas.LadybugDotTraceNode;
import edu.colorado.phet.ladybugmotion2d.canvas.LadybugFadeTraceNode;
import edu.colorado.phet.ladybugmotion2d.canvas.LadybugNode;
import edu.colorado.phet.ladybugmotion2d.canvas.ReturnLadybugButton;
import edu.colorado.phet.ladybugmotion2d.controlpanel.Dots$;
import edu.colorado.phet.ladybugmotion2d.controlpanel.Line$;
import edu.colorado.phet.ladybugmotion2d.controlpanel.PathVisibilityModel;
import edu.colorado.phet.ladybugmotion2d.controlpanel.VectorVisibilityModel;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel;
import edu.colorado.phet.scalacommon.CenteredBoxStrategy;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LadybugCanvas
extends PhetPCanvas {
    private final LadybugModel model;
    private final ModelViewTransform2D transform;
    private final boolean constructed;
    private final PNode worldNode;
    private final LadybugNode ladybugNode;
    private final LadybugDotTraceNode dotTrace;
    private final LadybugFadeTraceNode fadeTrace;

    public ModelViewTransform2D transform() {
        return this.transform;
    }

    public boolean constructed() {
        return this.constructed;
    }

    public PNode worldNode() {
        return this.worldNode;
    }

    public void addNode(PNode node) {
        this.worldNode().addChild(node);
    }

    public void addNode(int index, PNode node) {
        this.worldNode().addChild(index, node);
    }

    public LadybugNode ladybugNode() {
        return this.ladybugNode;
    }

    public LadybugDotTraceNode dotTrace() {
        return this.dotTrace;
    }

    public LadybugFadeTraceNode fadeTrace() {
        return this.fadeTrace;
    }

    public void setLadybugDraggable(boolean draggable) {
        this.ladybugNode().setDraggable(draggable);
    }

    public void updateWorldScale() {
        super.updateWorldScale();
        if (this.constructed()) {
            Point2D.Double topLeft = new Point2D.Double(0.0, 0.0);
            Point2D.Double bottomRight = new Point2D.Double(this.getWidth(), this.getHeight());
            Rectangle2D.Double out = new Rectangle2D.Double();
            out.setFrameFromDiagonal(this.tx$1(topLeft).getX(), this.tx$1(topLeft).getY(), this.tx$1(bottomRight).getX(), this.tx$1(bottomRight).getY());
            this.model.setBounds(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Point2D tx$1(Point2D pt) {
        void var3_3;
        Point2D intermediate = this.getWorldTransformStrategy().getTransform().inverseTransform(pt, null);
        Point2D model = this.transform().viewToModel(intermediate.getX(), intermediate.getY());
        return var3_3;
    }

    public LadybugCanvas(LadybugModel model, VectorVisibilityModel vectorVisibilityModel, PathVisibilityModel pathVisibilityModel, double modelWidth, double modelHeight) {
        this.model = model;
        super(new Dimension(1024, 768));
        this.setWorldTransformStrategy(new CenteredBoxStrategy(768.0, 768.0, this));
        this.transform = new ModelViewTransform2D(new Rectangle2D.Double(-modelWidth / (double)2, -modelHeight / (double)2, modelWidth, modelHeight), new Rectangle(0, 0, 768, 768), LadybugDefaults$.MODULE$.POSITIVE_Y_IS_UP());
        this.constructed = true;
        this.updateWorldScale();
        this.worldNode = new PNode();
        this.addWorldChild(this.worldNode());
        this.setBackground(new Color(200, 255, 240));
        this.ladybugNode = new LadybugNode(model, model.ladybug(), this.transform(), vectorVisibilityModel);
        this.addNode(this.ladybugNode());
        this.dotTrace = new LadybugDotTraceNode(model, this.transform(), pathVisibilityModel.pathType().valueEquals(Dots$.MODULE$), 0.7);
        this.addNode(this.dotTrace());
        this.fadeTrace = new LadybugFadeTraceNode(model, this.transform(), pathVisibilityModel.pathType().valueEquals(Line$.MODULE$), 0.7);
        this.addNode(this.fadeTrace());
        this.addNode(new ReturnLadybugButton(model, this));
    }
}

