/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.BorderFactory;

public class PhetPCanvas
extends PSwingCanvas {
    private static final Logger LOGGER = Logger.getLogger(PhetPCanvas.class.getCanonicalName());
    private TransformStrategy worldTransformStrategy;
    private PhetRootPNode phetRootNode;
    private AffineTransform transform;

    public PhetPCanvas() {
        this(new ConstantTransformStrategy(new AffineTransform()));
    }

    public PhetPCanvas(Dimension2D dimension2D) {
        this(new ConstantTransformStrategy(new AffineTransform()));
        this.setWorldTransformStrategy(new RenderingSizeStrategy(this, dimension2D));
    }

    public PhetPCanvas(TransformStrategy transformStrategy) {
        this.setAnimatingRenderQuality(1);
        this.setInteractingRenderQuality(1);
        this.worldTransformStrategy = transformStrategy;
        this.phetRootNode = new PhetRootPNode();
        this.getLayer().addChild(this.phetRootNode);
        this.removeInputEventListener(this.getZoomEventHandler());
        this.removeInputEventListener(this.getPanEventHandler());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetPCanvas.this.requestFocus();
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.requestFocus();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getBounds().getX() != (double)n || this.getBounds().getY() != (double)n2 || this.getBounds().getWidth() != (double)n3 || this.getBounds().getHeight() != (double)n4) {
            super.setBounds(n, n2, n3, n4);
            this.updateWorldScale();
            this.updateLayout();
        }
    }

    protected void updateLayout() {
    }

    public void setWorldTransformStrategy(TransformStrategy transformStrategy) {
        this.worldTransformStrategy = transformStrategy;
        this.updateWorldScale();
    }

    protected void updateWorldScale() {
        this.phetRootNode.setWorldTransform(this.worldTransformStrategy.getTransform());
    }

    public void addScreenChild(PNode pNode) {
        this.phetRootNode.addScreenChild(pNode);
    }

    public void addWorldChild(PNode pNode) {
        this.phetRootNode.addWorldChild(pNode);
    }

    public void addBoundsNode(Dimension2D dimension2D) {
        this.addWorldChild(new PPath(new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight())){
            {
                this.setStroke(new BasicStroke(3.0f));
                this.setStrokePaint(Color.RED);
                this.setPickable(false);
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        this.transform = ((Graphics2D)graphics).getTransform();
        super.paintComponent(graphics);
    }

    public static class CenteredStage
    implements TransformStrategy {
        public static final Dimension2D DEFAULT_STAGE_SIZE = new PDimension(1008.0, 679.0);
        private PhetPCanvas canvas;
        private Dimension2D stageSize;

        public CenteredStage(PhetPCanvas phetPCanvas, Dimension2D dimension2D) {
            this.canvas = phetPCanvas;
            this.stageSize = dimension2D;
        }

        public AffineTransform getTransform() {
            double d;
            double d2 = (double)this.canvas.getWidth() / this.stageSize.getWidth();
            double d3 = d2 < (d = (double)this.canvas.getHeight() / this.stageSize.getHeight()) ? d2 : d;
            d3 = d3 <= 0.0 ? 1.0 : d3;
            AffineTransform affineTransform = new AffineTransform();
            double d4 = d3 * this.stageSize.getWidth();
            double d5 = d3 * this.stageSize.getHeight();
            affineTransform.translate((double)(this.canvas.getWidth() / 2) - d4 / 2.0, (double)(this.canvas.getHeight() / 2) - d5 / 2.0);
            affineTransform.scale(d3, d3);
            return affineTransform;
        }
    }

    public static class ConstantTransformStrategy
    implements TransformStrategy {
        private AffineTransform affineTransform;

        public ConstantTransformStrategy(AffineTransform affineTransform) {
            this.affineTransform = affineTransform;
        }

        public AffineTransform getTransform() {
            return new AffineTransform(this.affineTransform);
        }
    }

    public static class RenderingSizeStrategy
    implements TransformStrategy {
        private PhetPCanvas phetPCanvas;
        private Dimension2D renderingSize;

        public RenderingSizeStrategy(PhetPCanvas phetPCanvas, Dimension2D dimension2D) {
            this.phetPCanvas = phetPCanvas;
            this.renderingSize = dimension2D;
            phetPCanvas.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    if (RenderingSizeStrategy.this.renderingSize == null) {
                        RenderingSizeStrategy.this.setRenderingSize();
                    }
                }
            });
        }

        public AffineTransform getTransform() {
            double d;
            double d2;
            if (this.renderingSize == null && this.phetPCanvas.isVisible()) {
                this.setRenderingSize();
            }
            double d3 = (d2 = this.getScaleX()) < (d = this.getScaleY()) ? d2 : d;
            d3 = d3 <= 0.0 ? 1.0 : d3;
            AffineTransform affineTransform = this.getPreprocessedTransform();
            affineTransform.scale(d3, d3);
            return affineTransform;
        }

        protected AffineTransform getPreprocessedTransform() {
            return new AffineTransform();
        }

        private void setRenderingSize() {
            this.setRenderingSize(this.phetPCanvas.getSize());
        }

        public void setRenderingSize(Dimension dimension) {
            this.renderingSize = new Dimension(dimension);
        }

        private double getScaleY() {
            return (double)this.phetPCanvas.getHeight() / this.renderingSize.getHeight();
        }

        private double getScaleX() {
            return (double)this.phetPCanvas.getWidth() / this.renderingSize.getWidth();
        }
    }

    public static interface TransformStrategy {
        public AffineTransform getTransform();
    }
}

