/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.control;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ComboBoxNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySimSharing;
import edu.colorado.phet.molarity.model.Solute;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoluteControlNode
extends PhetPNode {
    private static final PhetFont LABEL_FONT = new PhetFont(18);
    private static final PhetFont ITEM_FONT = new PhetFont(18);

    public SoluteControlNode(ArrayList<Solute> arrayList, final Property<Solute> property) {
        PText pText = new PText(MessageFormat.format(MolarityResources.Strings.PATTERN__0LABEL, MolarityResources.Strings.SOLUTE)){
            {
                this.setFont(LABEL_FONT);
            }
        };
        this.addChild(pText);
        final SoluteComboBoxNode soluteComboBoxNode = new SoluteComboBoxNode(arrayList, property.get());
        this.addChild(soluteComboBoxNode);
        double d = soluteComboBoxNode.getFullBoundsReference().getHeight() - pText.getFullBoundsReference().getHeight();
        pText.setOffset(0.0, Math.max(0.0, d / 2.0));
        soluteComboBoxNode.setOffset(pText.getFullBoundsReference().getMaxX() + 5.0, Math.min(0.0, d / 2.0));
        soluteComboBoxNode.selectedItem.addObserver(new VoidFunction1<Solute>(){

            @Override
            public void apply(Solute solute) {
                property.set(solute);
            }
        });
        property.addObserver(new VoidFunction1<Solute>(){

            @Override
            public void apply(Solute solute) {
                soluteComboBoxNode.selectedItem.set(solute);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoluteComboBoxNode
    extends ComboBoxNode<Solute> {
        public SoluteComboBoxNode(ArrayList<Solute> arrayList, Solute solute) {
            super(MolaritySimSharing.UserComponents.soluteComboBox, new Function1<Solute, String>(){

                @Override
                public String apply(Solute solute) {
                    return solute.name;
                }
            }, arrayList, solute, new Function1<Solute, PNode>(){

                @Override
                public PNode apply(Solute solute) {
                    return new SoluteItemNode(solute);
                }
            });
        }
    }

    private static class SoluteItemNode
    extends PComposite {
        public SoluteItemNode(final Solute solute) {
            PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0)){
                {
                    super(shape);
                    Color color = solute.solutionColor.getMax();
                    this.setPaint(color);
                    this.setStrokePaint(color.darker().darker());
                    this.setStroke(new BasicStroke(0.25f));
                }
            };
            this.addChild(pPath);
            HTMLNode hTMLNode = new HTMLNode(){
                {
                    this.setHTML(solute.name);
                    this.setFont(ITEM_FONT);
                }
            };
            this.addChild(hTMLNode);
            pPath.setOffset(0.0, Math.max(0.0, (hTMLNode.getFullBoundsReference().getHeight() - pPath.getFullBoundsReference().getHeight()) / 2.0));
            hTMLNode.setOffset(pPath.getFullBoundsReference().getMaxX() + 5.0, Math.max(0.0, (pPath.getFullBoundsReference().getHeight() - hTMLNode.getFullBoundsReference().getHeight()) / 2.0));
        }
    }
}

