/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.control;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.PrecisionDecimal;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.molarity.MolarityConstants;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySimSharing;
import edu.colorado.phet.molarity.view.DualLabelNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalSliderNode
extends PhetPNode {
    private static final PDimension THUMB_SIZE = new PDimension(45.0, 15.0);
    private final Function modelToView;
    private final PNode trackNode;
    private final ThumbNode thumbNode;

    public VerticalSliderNode(IUserComponent iUserComponent, String string, String string2, String string3, String string4, PDimension pDimension, Property<Double> property, DoubleRange doubleRange, String string5, Property<Boolean> property2) {
        this(iUserComponent, string, string2, string3, string4, pDimension, Color.BLACK, new Color(200, 200, 200, 140), property, doubleRange, string5, property2);
    }

    public VerticalSliderNode(IUserComponent iUserComponent, String string, String string2, String string3, String string4, final PDimension pDimension, Paint paint, final Paint paint2, Property<Double> property, DoubleRange doubleRange, String string5, Property<Boolean> property2) {
        this.modelToView = new Function.LinearFunction(doubleRange.getMin(), doubleRange.getMax(), pDimension.getHeight(), 0.0);
        HTMLNode hTMLNode = new HTMLNode(string, Color.BLACK, MolarityConstants.TITLE_FONT);
        HTMLNode hTMLNode2 = new HTMLNode(string2, Color.BLACK, MolarityConstants.SUBTITLE_FONT);
        this.trackNode = new TrackNode(UserComponentChain.chain(iUserComponent, MolaritySimSharing.UserComponents.track), pDimension, paint, property, doubleRange, this.modelToView.createInverse());
        PPath pPath = new PPath(){
            {
                this.setPathTo(new RoundRectangle2D.Double(-7.0, -7.0, pDimension.getWidth() + 14.0, pDimension.getHeight() + 14.0, 10.0, 10.0));
                this.setPaint(paint2);
                this.setStroke(null);
            }
        };
        this.thumbNode = new ThumbNode(UserComponentChain.chain(iUserComponent, MolaritySimSharing.UserComponents.thumb), THUMB_SIZE, this, this.trackNode, doubleRange, property, string5, property2);
        DualLabelNode dualLabelNode = new DualLabelNode(MolarityConstants.RANGE_FORMAT.format(doubleRange.getMin()), string3, property2, MolarityConstants.RANGE_FONT);
        DualLabelNode dualLabelNode2 = new DualLabelNode(MolarityConstants.RANGE_FORMAT.format(doubleRange.getMax()), string4, property2, MolarityConstants.RANGE_FONT);
        this.addChild(hTMLNode);
        this.addChild(hTMLNode2);
        this.addChild(dualLabelNode2);
        this.addChild(dualLabelNode);
        this.addChild(pPath);
        this.addChild(this.trackNode);
        this.addChild(this.thumbNode);
        dualLabelNode2.setOffset(this.trackNode.getFullBoundsReference().getCenterX(), this.trackNode.getFullBoundsReference().getMinY() - this.thumbNode.getFullBoundsReference().getHeight() / 2.0 - dualLabelNode2.getFullBoundsReference().getHeight() - 1.0);
        dualLabelNode.setOffset(this.trackNode.getFullBoundsReference().getCenterX(), this.trackNode.getFullBoundsReference().getMaxY() + this.thumbNode.getFullBoundsReference().getHeight() / 2.0 + 1.0);
        hTMLNode2.setOffset(this.trackNode.getFullBoundsReference().getCenterX() - hTMLNode2.getFullBoundsReference().getWidth() / 2.0, dualLabelNode2.getFullBoundsReference().getMinY() - hTMLNode2.getFullBoundsReference().getHeight() - 8.0);
        hTMLNode.setOffset(this.trackNode.getFullBoundsReference().getCenterX() - hTMLNode.getFullBoundsReference().getWidth() / 2.0, hTMLNode2.getFullBoundsReference().getMinY() - hTMLNode.getFullBoundsReference().getHeight() - 2.0);
        this.thumbNode.setOffset(this.trackNode.getFullBoundsReference().getCenterX(), this.trackNode.getFullBoundsReference().getCenterY());
        property.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                VerticalSliderNode.this.thumbNode.setOffset(VerticalSliderNode.this.thumbNode.getXOffset(), VerticalSliderNode.this.modelToView.evaluate(d));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbDragHandler
    extends SliderThumbDragHandler {
        private final Property<Double> modelValue;

        public ThumbDragHandler(IUserComponent iUserComponent, PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, final Property<Double> property) {
            super(iUserComponent, false, SliderThumbDragHandler.Orientation.VERTICAL, pNode, pNode2, pNode3, doubleRange, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    property.set(new PrecisionDecimal(d, 2).getValue());
                }
            });
            this.modelValue = property;
        }

        @Override
        protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
            return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)ParameterKeys.value, this.modelValue.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbNode
    extends PComposite {
        private static final Stroke THUMB_STROKE = new BasicStroke(1.0f);
        private static final Color THUMB_NORMAL_COLOR = new Color(89, 156, 212);
        private static final Color THUMB_HIGHLIGHT_COLOR = THUMB_NORMAL_COLOR.brighter();
        private static final Color THUMB_STROKE_COLOR = Color.BLACK;
        private static final Color THUMB_CENTER_LINE_COLOR = Color.WHITE;
        private final PText valueNode;

        public ThumbNode(IUserComponent iUserComponent, final PDimension pDimension, PNode pNode, PNode pNode2, DoubleRange doubleRange, Property<Double> property, final String string, Property<Boolean> property2) {
            PPath pPath = new PPath(){
                {
                    double d = 0.25 * pDimension.getWidth();
                    this.setPathTo(new RoundRectangle2D.Double(-pDimension.getWidth() / 2.0, -pDimension.getHeight() / 2.0, pDimension.getWidth(), pDimension.getHeight(), d, d));
                    this.setPaint(THUMB_NORMAL_COLOR);
                    this.setStroke(THUMB_STROKE);
                    this.setStrokePaint(THUMB_STROKE_COLOR);
                }
            };
            PPath pPath2 = new PPath(){
                {
                    this.setPathTo(new Line2D.Double(-(pDimension.getWidth() / 2.0) + 3.0, 0.0, pDimension.getWidth() / 2.0 - 3.0, 0.0));
                    this.setStrokePaint(THUMB_CENTER_LINE_COLOR);
                }
            };
            this.valueNode = new PText("?"){
                {
                    this.setFont(MolarityConstants.VALUE_FONT);
                }
            };
            this.valueNode.setOffset(pPath.getFullBoundsReference().getMaxX() + 5.0, pPath.getFullBoundsReference().getCenterY() - this.valueNode.getFullBoundsReference().getHeight() / 2.0);
            this.addChild(pPath);
            this.addChild(pPath2);
            this.addChild(this.valueNode);
            property2.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    ThumbNode.this.valueNode.setVisible(bl);
                }
            });
            property.addObserver(new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    ThumbNode.this.valueNode.setText(MessageFormat.format(MolarityResources.Strings.PATTERN__0VALUE__1UNITS, MolarityConstants.VALUE_FORMAT.format(d), string));
                }
            });
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(pPath, THUMB_NORMAL_COLOR, THUMB_HIGHLIGHT_COLOR));
            this.addInputEventListener(new ThumbDragHandler(iUserComponent, pNode, pNode2, this, doubleRange, property));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrackNode
    extends PPath {
        public TrackNode(IUserComponent iUserComponent, PDimension pDimension, Paint paint, final Property<Double> property, final DoubleRange doubleRange, final Function function) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
            this.setPaint(paint);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new SimSharingDragHandler(iUserComponent, UserComponentTypes.slider){

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    this.handleEvent(pInputEvent);
                }

                public void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    this.handleEvent(pInputEvent);
                }

                private void handleEvent(PInputEvent pInputEvent) {
                    double d = pInputEvent.getPositionRelativeTo(TrackNode.this).getY();
                    double d2 = Math.min(Math.max(function.evaluate(d), doubleRange.getMin()), doubleRange.getMax());
                    property.set(d2);
                }
            });
        }
    }
}

