/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.model;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.ColorRange;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySymbols;
import edu.colorado.phet.molarity.model.Solute;
import edu.colorado.phet.molarity.model.Solution;
import edu.colorado.phet.molarity.model.Solvent;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MolarityModel
implements Resettable {
    private static final DoubleRange SOLUTE_AMOUNT_RANGE = new DoubleRange(0.0, 1.0, 0.5);
    private static final DoubleRange SOLUTION_VOLUME_RANGE = new DoubleRange(0.2, 1.0, 0.5);
    private static final DoubleRange CONCENTRATION_RANGE;
    private static final DoubleRange CONCENTRATION_DISPLAY_RANGE;
    private final ArrayList<Solute> solutes = new ArrayList<Solute>(){
        {
            this.add(new Solute(MolarityResources.Strings.DRINK_MIX, MolaritySymbols.DRINK_MIX, 5.95, new ColorRange(new Color(255, 225, 225), Color.RED), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.COBALT_II_NITRATE, MolaritySymbols.COBALT_II_NITRATE, 5.65, new ColorRange(new Color(255, 225, 225), Color.RED), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.COBALT_CHLORIDE, MolaritySymbols.COBALT_CHLORIDE, 4.35, new ColorRange(new Color(255, 242, 242), new Color(0xFF6A6A)), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.POTASSIUM_DICHROMATE, MolaritySymbols.POTASSIUM_DICHROMATE, 0.5, new ColorRange(new Color(255, 232, 210), new Color(0xFF7F00)), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.GOLD_III_CHLORIDE, MolaritySymbols.GOLD_III_CHLORIDE, 2.25, new ColorRange(new Color(255, 255, 199), new Color(16766720)), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.POTASSIUM_CHROMATE, MolaritySymbols.POTASSIUM_CHROMATE, 3.35, new ColorRange(new Color(255, 255, 199), Color.YELLOW), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.NICKEL_II_CHLORIDE, MolaritySymbols.NICKEL_II_CHLORIDE, 5.2, new ColorRange(new Color(234, 244, 234), new Color(32768)), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.COPPER_SULFATE, MolaritySymbols.COPPER_SULFATE, 1.4, new ColorRange(new Color(222, 238, 255), new Color(2003199)), 5.0, 200));
            this.add(new Solute(MolarityResources.Strings.POTASSIUM_PERMANGANATE, MolaritySymbols.POTASSIUM_PERMANGANATE, 0.5, new ColorRange(new Color(255, 0, 255), new Color(0x8B008B)), Color.BLACK, 5.0, 200));
        }
    };
    public final Solution solution = new Solution(new Solvent.Water(), this.solutes.get(0), SOLUTE_AMOUNT_RANGE.getDefault(), SOLUTION_VOLUME_RANGE.getDefault());

    public ArrayList<Solute> getSolutes() {
        return new ArrayList<Solute>(this.solutes);
    }

    public DoubleRange getSoluteAmountRange() {
        return SOLUTE_AMOUNT_RANGE;
    }

    public DoubleRange getSolutionVolumeRange() {
        return SOLUTION_VOLUME_RANGE;
    }

    public DoubleRange getConcentrationDisplayRange() {
        return CONCENTRATION_DISPLAY_RANGE;
    }

    @Override
    public void reset() {
        this.solution.reset();
    }

    static {
        CONCENTRATION_DISPLAY_RANGE = CONCENTRATION_RANGE = new DoubleRange(SOLUTE_AMOUNT_RANGE.getMin() / SOLUTION_VOLUME_RANGE.getMax(), SOLUTE_AMOUNT_RANGE.getMax() / SOLUTION_VOLUME_RANGE.getMin());
        assert (SOLUTION_VOLUME_RANGE.getMin() > 0.0);
    }
}

