/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.util.logging.Logger;

class AbstractMolarityCanvas
extends PhetPCanvas
implements Resettable {
    private static final Logger LOGGER = LoggingUtils.getLogger(AbstractMolarityCanvas.class.getCanonicalName());
    private static final Dimension2D STAGE_SIZE = new PDimension(1008.0, 679.0);
    private static final Color CANVAS_COLOR = Color.WHITE;
    private static final boolean SHOW_STAGE_BOUNDS = PhetApplication.getInstance().getSimInfo().hasCommandLineArg("-showStageBounds");
    private final PNode rootNode;

    protected AbstractMolarityCanvas() {
        this.setBackground(CANVAS_COLOR);
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, STAGE_SIZE));
        if (SHOW_STAGE_BOUNDS) {
            this.addBoundsNode(STAGE_SIZE);
        }
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
    }

    protected void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    protected void centerRootNodeOnStage() {
        this.rootNode.setOffset((STAGE_SIZE.getWidth() - this.rootNode.getFullBoundsReference().getWidth()) / 2.0 - PNodeLayoutUtils.getOriginXOffset(this.rootNode), (STAGE_SIZE.getHeight() - this.rootNode.getFullBoundsReference().getHeight()) / 2.0 - PNodeLayoutUtils.getOriginYOffset(this.rootNode));
    }

    protected void scaleRootNodeToFitStage() {
        double d = STAGE_SIZE.getWidth() / this.rootNode.getFullBoundsReference().getWidth();
        double d2 = STAGE_SIZE.getHeight() / this.rootNode.getFullBoundsReference().getHeight();
        if (d < 1.0 || d2 < 1.0) {
            double d3 = Math.min(d, d2);
            LOGGER.info("rootNode won't fit in the play area, scaling rootNode by " + d3 + " for " + this.getClass().getName());
            this.rootNode.scale(d3);
        }
    }

    public void reset() {
    }
}

