/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BufferedPNode
extends PhetPNode {
    private PNode managedNode;
    private RescaledNode rescaledNode;
    private boolean buffered;

    public BufferedPNode(final PhetPCanvas phetPCanvas, final PNode pNode) {
        this.managedNode = pNode;
        this.rescaledNode = new RescaledNode(phetPCanvas, pNode.toImage());
        this.buffered = true;
        this.addChild(pNode);
        pNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "children") {
                    BufferedPNode.this.rescaledNode = new RescaledNode(phetPCanvas, pNode.toImage());
                    BufferedPNode.this.update();
                }
            }
        });
        this.update();
    }

    private void update() {
        this.removeAllChildren();
        if (this.buffered) {
            this.addChild(this.rescaledNode);
        } else {
            this.addChild(this.managedNode);
        }
    }

    private static class RescaledNode
    extends PImage {
        private PhetPCanvas canvas;
        BufferedImage rescaledImage;
        BufferedImage originalImage;

        public RescaledNode(PhetPCanvas phetPCanvas, Image image) {
            super(image);
            this.canvas = phetPCanvas;
            this.originalImage = BufferedImageUtils.toBufferedImage(image);
            this.updateImage(image.getWidth(null));
        }

        private void updateImage(int n) {
            this.rescaledImage = BufferedImageUtils.rescaleXMaintainAspectRatio(BufferedImageUtils.copyImage(this.originalImage), n);
        }

        protected void paint(PPaintContext pPaintContext) {
            if (this.rescaledImage != null) {
                PBounds pBounds = this.getGlobalFullBounds();
                this.canvas.getPhetRootNode().globalToScreen(pBounds);
                int n = (int)((RectangularShape)pBounds).getWidth();
                if (n != this.rescaledImage.getWidth()) {
                    this.updateImage(n);
                }
                Graphics2D graphics2D = pPaintContext.getGraphics();
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setTransform(this.canvas.getTransform());
                graphics2D.drawRenderedImage(this.rescaledImage, AffineTransform.getTranslateInstance(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY()));
                graphics2D.setTransform(affineTransform);
            }
        }
    }
}

