/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class SphericalNode
extends PhetPNode {
    private final PPath _pathNode;
    private final PImage _imageNode;
    private boolean _convertToImage;

    public SphericalNode(double d, Paint paint, Stroke stroke, Paint paint2, boolean bl) {
        this._convertToImage = bl;
        this._pathNode = new PhetPPath();
        this._pathNode.setPaint(paint);
        this._pathNode.setStroke(stroke);
        this._pathNode.setStrokePaint(paint2);
        this._imageNode = new PImage();
        if (bl) {
            this.addChild(this._imageNode);
        } else {
            this.addChild(this._pathNode);
        }
        this.setDiameter(d);
    }

    public double getDiameter() {
        return this.getFullBoundsReference().getWidth();
    }

    public void setDiameter(double d) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
        this._pathNode.setPathTo(double_);
        this.update();
    }

    public void setPaint(Paint paint) {
        this._pathNode.setPaint(paint);
        this.update();
    }

    private void update() {
        if (this._convertToImage) {
            this._imageNode.setImage(this._pathNode.toImage());
            PBounds pBounds = this._imageNode.getFullBoundsReference();
            this._imageNode.setOffset(-pBounds.getWidth() / 2.0, -pBounds.getHeight() / 2.0);
        }
    }
}

