/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.control;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.rutherfordscattering.RSConstants;
import edu.colorado.phet.rutherfordscattering.RSResources;
import edu.colorado.phet.rutherfordscattering.control.RSAbstractControlPanel;
import edu.colorado.phet.rutherfordscattering.model.Gun;
import edu.colorado.phet.rutherfordscattering.model.RutherfordAtom;
import edu.colorado.phet.rutherfordscattering.module.RutherfordAtomModule;
import edu.colorado.phet.rutherfordscattering.view.LegendPanel;
import edu.colorado.phet.rutherfordscattering.view.RutherfordAtomNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RutherfordAtomControlPanel
extends RSAbstractControlPanel
implements Observer {
    private RutherfordAtomModule _module;
    private Gun _gun;
    private RutherfordAtom _atom;
    private RutherfordAtomNode _atomNode;
    private LinearValueControl _energyControl;
    private ChangeListener _energyListener;
    private JCheckBox _tracesCheckBox;
    private LinearValueControl _protonsControl;
    private ChangeListener _protonsListener;
    private LinearValueControl _neutronsControl;
    private ChangeListener _neutronsListener;

    public RutherfordAtomControlPanel(RutherfordAtomModule rutherfordAtomModule) {
        super(rutherfordAtomModule);
        this._module = rutherfordAtomModule;
        this._module = rutherfordAtomModule;
        this._gun = this._module.getGun();
        this._gun.addObserver(this);
        this._atom = this._module.getAtom();
        this._atom.addObserver(this);
        this._atomNode = this._module.getAtomNode();
        LegendPanel legendPanel = new LegendPanel(0.85, RSConstants.TITLE_FONT, RSConstants.CONTROL_FONT, RSConstants.TITLED_BORDER_STYLE);
        JPanel jPanel = new JPanel();
        Serializable serializable = new TitledBorder(RSResources.getString("string.alphaParticleProperties"));
        ((TitledBorder)serializable).setTitleFont(RSConstants.TITLE_FONT);
        ((TitledBorder)serializable).setBorder(RSConstants.TITLED_BORDER_STYLE);
        jPanel.setBorder((Border)((Object)serializable));
        double d = this._gun.getSpeed();
        double d2 = this._gun.getMinSpeed();
        double d3 = this._gun.getMaxSpeed();
        String string = "0";
        String string2 = RSResources.getString("string.energy");
        String string3 = "";
        this._energyControl = new LinearValueControl(d2, d3, string2, string, string3);
        this._energyControl.setValue(d);
        this._energyControl.setFont(RSConstants.CONTROL_FONT);
        this._energyControl.setTextFieldEditable(true);
        this._energyControl.setTextFieldVisible(false);
        this._energyControl.addTickLabel(d2, RSResources.getString("string.minEnergy"));
        this._energyControl.addTickLabel(d3, RSResources.getString("string.maxEnergy"));
        this._energyListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RutherfordAtomControlPanel.this._module.removeAllAlphaParticles();
                RutherfordAtomControlPanel.this._gun.setRunning(false);
                if (!RutherfordAtomControlPanel.this._energyControl.isAdjusting()) {
                    RutherfordAtomControlPanel.this.handleEnergyChange();
                    RutherfordAtomControlPanel.this._gun.setRunning(true);
                }
            }
        };
        this._energyControl.addChangeListener(this._energyListener);
        this._tracesCheckBox = new JCheckBox(RSResources.getString("string.showTraces"));
        this._tracesCheckBox.setFont(RSConstants.CONTROL_FONT);
        this._tracesCheckBox.setSelected(this._module.getTracesNode().isEnabled());
        this._tracesCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RutherfordAtomControlPanel.this.handleTracesChanged();
            }
        });
        Serializable serializable2 = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        int n = 0;
        int n2 = 0;
        ((EasyGridBagLayout)serializable2).addComponent(this._energyControl, n++, n2);
        ((EasyGridBagLayout)serializable2).addFilledComponent(new JSeparator(), n++, n2, 2);
        ((EasyGridBagLayout)serializable2).addComponent(this._tracesCheckBox, n++, n2);
        serializable = new JPanel();
        serializable2 = new TitledBorder(RSResources.getString("string.atomProperties"));
        ((TitledBorder)serializable2).setTitleFont(RSConstants.TITLE_FONT);
        ((TitledBorder)serializable2).setBorder(RSConstants.TITLED_BORDER_STYLE);
        ((JComponent)serializable).setBorder((Border)((Object)serializable2));
        n = this._atom.getNumberOfProtons();
        n2 = this._atom.getMinNumberOfProtons();
        int n3 = this._atom.getMaxNumberOfProtons();
        String string4 = "0";
        String string5 = RSResources.getString("string.numberOfProtons");
        string = "";
        int n4 = 3;
        this._protonsControl = new LinearValueControl(n2, n3, string5, string4, string);
        this._protonsControl.setValue(n);
        this._protonsControl.setUpDownArrowDelta(1.0);
        this._protonsControl.setFont(RSConstants.CONTROL_FONT);
        this._protonsControl.setTextFieldEditable(true);
        this._protonsControl.setTextFieldColumns(n4);
        this._protonsListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RutherfordAtomControlPanel.this.handleProtonsChange();
            }
        };
        this._protonsControl.addChangeListener(this._protonsListener);
        n = this._atom.getNumberOfNeutrons();
        n2 = this._atom.getMinNumberOfNeutrons();
        n3 = this._atom.getMaxNumberOfNeutrons();
        string4 = "0";
        string5 = RSResources.getString("string.numberOfNeutrons");
        string = "";
        n4 = 3;
        this._neutronsControl = new LinearValueControl(n2, n3, string5, string4, string);
        this._neutronsControl.setValue(n);
        this._neutronsControl.setUpDownArrowDelta(1.0);
        this._neutronsControl.setFont(RSConstants.CONTROL_FONT);
        this._neutronsControl.setTextFieldEditable(true);
        this._neutronsControl.setTextFieldColumns(n4);
        this._neutronsListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RutherfordAtomControlPanel.this.handleNeutronsChange();
            }
        };
        this._neutronsControl.addChangeListener(this._neutronsListener);
        Serializable serializable3 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable3));
        ((EasyGridBagLayout)serializable3).setAnchor(17);
        n2 = 0;
        n3 = 0;
        ((EasyGridBagLayout)serializable3).addComponent(this._protonsControl, n2++, n3);
        ((EasyGridBagLayout)serializable3).addFilledComponent(new JSeparator(), n2++, n3, 2);
        ((EasyGridBagLayout)serializable3).addComponent(this._neutronsControl, n2++, n3);
        this.addControlFullWidth(legendPanel);
        this.addVerticalSpace(20);
        this.addControlFullWidth(jPanel);
        this.addVerticalSpace(20);
        this.addControlFullWidth((Component)serializable);
        this.addVerticalSpace(20);
        serializable3 = this.addResetAllButton(rutherfordAtomModule);
        ((JComponent)serializable3).setFont(RSConstants.CONTROL_FONT);
    }

    public void setTracesEnabled(boolean bl) {
        this._tracesCheckBox.setSelected(bl);
    }

    private void handleEnergyChange() {
        this._module.removeAllAlphaParticles();
        this._gun.setRunning(false);
        double d = this._energyControl.getValue();
        this._gun.deleteObserver(this);
        this._gun.setSpeed(d);
        this._gun.addObserver(this);
        if (!this._energyControl.isAdjusting()) {
            this._gun.setRunning(true);
        }
    }

    private void handleTracesChanged() {
        boolean bl = this._tracesCheckBox.isSelected();
        this._module.getTracesNode().setEnabled(bl);
    }

    private void handleProtonsChange() {
        this._module.removeAllAlphaParticles();
        this._gun.setRunning(false);
        this._atomNode.setOutlineModeEnabled(true);
        int n = (int)this._protonsControl.getValue();
        this._atom.deleteObserver(this);
        this._atom.setNumberOfProtons(n);
        this._atom.addObserver(this);
        if (!this._protonsControl.isAdjusting()) {
            this._gun.setRunning(true);
            this._atomNode.setOutlineModeEnabled(false);
        }
    }

    private void handleNeutronsChange() {
        this._module.removeAllAlphaParticles();
        this._gun.setRunning(false);
        this._atomNode.setOutlineModeEnabled(true);
        int n = (int)this._neutronsControl.getValue();
        this._atom.deleteObserver(this);
        this._atom.setNumberOfNeutrons(n);
        this._atom.addObserver(this);
        if (!this._neutronsControl.isAdjusting()) {
            this._gun.setRunning(true);
            this._atomNode.setOutlineModeEnabled(false);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._gun && object == "speed") {
            this._energyControl.removeChangeListener(this._energyListener);
            this._energyControl.setValue(this._gun.getSpeed());
            this._energyControl.addChangeListener(this._energyListener);
        } else if (observable == this._atom) {
            if (object == "numberOfProtons") {
                this._protonsControl.removeChangeListener(this._protonsListener);
                this._protonsControl.setValue(this._atom.getNumberOfProtons());
                this._protonsControl.addChangeListener(this._protonsListener);
            } else if (object == "numberOfNeutrons") {
                this._neutronsControl.removeChangeListener(this._neutronsListener);
                this._neutronsControl.setValue(this._atom.getNumberOfNeutrons());
                this._neutronsControl.addChangeListener(this._neutronsListener);
            }
        }
    }
}

