/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.model;

import edu.colorado.phet.rutherfordscattering.model.AbstractAtom;
import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import java.awt.geom.Point2D;

public class PlumPuddingAtom
extends AbstractAtom {
    private final double _radius;

    public PlumPuddingAtom(Point2D point2D, double d) {
        super(point2D, 0.0);
        this._radius = d;
    }

    public double getRadius() {
        return this._radius;
    }

    public int getNumberOfElectrons() {
        return 79;
    }

    public void moveAlphaParticle(double d, AlphaParticle alphaParticle) {
        double d2 = alphaParticle.getSpeed();
        double d3 = d2 * d;
        double d4 = alphaParticle.getOrientation();
        double d5 = Math.cos(d4) * d3;
        double d6 = Math.sin(d4) * d3;
        double d7 = alphaParticle.getX() + d5;
        double d8 = alphaParticle.getY() + d6;
        alphaParticle.setPosition(d7, d8);
    }

    public void stepInTime(double d) {
    }
}

