/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.rutherfordscattering.event.GunFiredEvent;
import edu.colorado.phet.rutherfordscattering.event.GunFiredListener;
import edu.colorado.phet.rutherfordscattering.event.ParticleEvent;
import edu.colorado.phet.rutherfordscattering.event.ParticleListener;
import edu.colorado.phet.rutherfordscattering.model.AbstractAtom;
import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import edu.colorado.phet.rutherfordscattering.model.Gun;
import edu.colorado.phet.rutherfordscattering.model.Space;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class RSModel
extends ClockAdapter
implements GunFiredListener {
    private Gun _gun;
    private Space _space;
    private AbstractAtom _atom;
    private ArrayList _alphaParticles;
    private EventListenerList _listenerList;

    public RSModel(IClock iClock, Gun gun, Space space, AbstractAtom abstractAtom) {
        iClock.addClockListener(this);
        this._gun = gun;
        this._gun.addGunFiredListener(this);
        this._space = space;
        this._atom = abstractAtom;
        this._alphaParticles = new ArrayList();
        this._listenerList = new EventListenerList();
    }

    public Gun getGun() {
        return this._gun;
    }

    private void addParticle(AlphaParticle alphaParticle) {
        this._alphaParticles.add(alphaParticle);
        this.fireParticleAdded(new ParticleEvent(this, alphaParticle));
    }

    private void removeParticle(AlphaParticle alphaParticle) {
        this._alphaParticles.remove(alphaParticle);
        this.fireParticleRemoved(new ParticleEvent(this, alphaParticle));
    }

    public void removeAllAlphaParticles() {
        if (this._alphaParticles.size() > 0) {
            Object[] objectArray = this._alphaParticles.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeParticle((AlphaParticle)objectArray[i]);
            }
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTimeChange();
        this._gun.stepInTime(d);
        this._atom.stepInTime(d);
        this.moveParticles(d);
        this.cullParticles();
    }

    private void moveParticles(double d) {
        if (this._alphaParticles.size() > 0) {
            Object[] objectArray = this._alphaParticles.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                AlphaParticle alphaParticle = (AlphaParticle)objectArray[i];
                this._atom.moveAlphaParticle(d, alphaParticle);
            }
        }
    }

    private void cullParticles() {
        if (this._alphaParticles.size() > 0) {
            Object[] objectArray = this._alphaParticles.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                AlphaParticle alphaParticle = (AlphaParticle)objectArray[i];
                if (this._space.contains(alphaParticle)) continue;
                this.removeParticle(alphaParticle);
            }
        }
    }

    public void alphaParticleFired(GunFiredEvent gunFiredEvent) {
        this.addParticle(gunFiredEvent.getAlphaParticle());
    }

    public void addParticleListener(ParticleListener particleListener) {
        this._listenerList.add(ParticleListener.class, particleListener);
    }

    public void removeParticleListener(ParticleListener particleListener) {
        this._listenerList.remove(ParticleListener.class, particleListener);
    }

    private void fireParticleAdded(ParticleEvent particleEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ParticleListener.class) continue;
            ((ParticleListener)objectArray[i + 1]).particleAdded(particleEvent);
        }
    }

    private void fireParticleRemoved(ParticleEvent particleEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ParticleListener.class) continue;
            ((ParticleListener)objectArray[i + 1]).particleRemoved(particleEvent);
        }
    }
}

