/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.model;

import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import edu.colorado.phet.rutherfordscattering.model.RutherfordAtom;
import java.awt.Dimension;
import java.text.DecimalFormat;

public class RutherfordScattering {
    private static boolean REPORT_FAILURES_VERBOSE = false;
    private static boolean CULL_PROBLEM_PARTICLES = true;
    private static final DecimalFormat F = new DecimalFormat("0.00");

    private RutherfordScattering() {
    }

    public static void moveParticle(double d, AlphaParticle alphaParticle, RutherfordAtom rutherfordAtom, Dimension dimension) {
        assert (d > 0.0);
        assert (dimension.getWidth() == dimension.getHeight());
        double d2 = dimension.getWidth();
        int n = rutherfordAtom.getNumberOfProtons();
        int n2 = rutherfordAtom.getDefaultNumberOfProtons();
        double d3 = alphaParticle.getSpeed();
        double d4 = alphaParticle.getInitialSpeed();
        double d5 = alphaParticle.getDefaultSpeed();
        double d6 = Math.abs(alphaParticle.getInitialPosition().getX() - rutherfordAtom.getX());
        if (d6 == 0.0) {
            d6 = 1.0E-5;
        }
        double d7 = alphaParticle.getInitialPosition().getY() - rutherfordAtom.getY();
        d7 *= -1.0;
        double d8 = alphaParticle.getX() - rutherfordAtom.getX();
        boolean bl = false;
        if (d8 < 0.0) {
            d8 *= -1.0;
            bl = true;
        }
        assert (d8 >= 0.0);
        double d9 = alphaParticle.getY() - rutherfordAtom.getY();
        double d10 = d2 / 8.0 * ((double)n / (double)n2) * (d5 * d5 / (d4 * d4));
        double d11 = Math.sqrt(d6 * d6 + d7 * d7);
        double d12 = 0.5 * (d6 + Math.sqrt(-2.0 * d10 * d11 - 2.0 * d10 * d7 + d6 * d6));
        double d13 = Math.sqrt(d8 * d8 + (d9 *= -1.0) * d9);
        double d14 = Math.atan2(d8, -d9);
        double d15 = d12 * Math.cos(d14) - d10 / 2.0 * Math.sin(d14);
        double d16 = d14 + d12 * d12 * d3 * d / (d13 * Math.sqrt(Math.pow(d12, 4.0) + d13 * d13 * d15 * d15));
        double d17 = Math.abs(d12 * d12 / (d12 * Math.sin(d16) + d10 / 2.0 * (Math.cos(d16) - 1.0)));
        double d18 = d4 * Math.sqrt(1.0 - d10 / d17);
        double d19 = d17 * Math.sin(d16);
        if (bl) {
            d19 *= -1.0;
        }
        double d20 = -d17 * Math.cos(d16);
        boolean bl2 = false;
        if (!(d12 > 0.0) || !(d18 > 0.0)) {
            System.err.println("ERROR: RutherfordScattering.moveParticle from (x,y)=" + RutherfordScattering.pointToString(d8, d9) + " to " + "(xNew,yNew)=" + RutherfordScattering.pointToString(d19, d20) + " : " + "b=" + d12 + " newSpeed=" + d18);
            bl2 = true;
        }
        if (bl2 && REPORT_FAILURES_VERBOSE) {
            System.err.println("DEBUG: RutherfordScattering.moveParticle [");
            System.err.println("  particle id=" + alphaParticle.getId());
            System.err.println("  constants:");
            System.err.println("    dt=" + d);
            System.err.println("    b=" + d12);
            System.err.println("    L=" + d2);
            System.err.println("    D=" + d10);
            System.err.println("    (x0,y0)=" + RutherfordScattering.pointToString(d6, d7));
            System.err.println("    s0=" + d4);
            System.err.println("    sd=" + d5);
            System.err.println("    p=" + n);
            System.err.println("    pd=" + n2);
            System.err.println("  current state:");
            System.err.println("    (x,y)=" + RutherfordScattering.pointToString(d8, d9));
            System.err.println("    (r,phi)=" + RutherfordScattering.pointToString(d13, Math.toDegrees(d14)));
            System.err.println("    s=" + d3);
            System.err.println("  new state:");
            System.err.println("    (xNew,yNew)=" + RutherfordScattering.pointToString(d19, d20));
            System.err.println("    (rNew,phiNew)=" + RutherfordScattering.pointToString(d17, Math.toDegrees(d16)));
            System.err.println("    sNew=" + d18);
            System.err.println("]");
        }
        if (bl2 && CULL_PROBLEM_PARTICLES) {
            d19 = 10.0 * d2;
            d20 = 10.0 * d2;
            d18 = d3;
            d16 = d14;
        }
        d20 *= -1.0;
        alphaParticle.setPosition(d19 += rutherfordAtom.getX(), d20 += rutherfordAtom.getY());
        alphaParticle.setSpeed(d18);
        alphaParticle.setOrientation(d16);
    }

    private static String pointToString(double d, double d2) {
        return "(" + F.format(d) + "," + F.format(d2) + ")";
    }
}

