/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.module;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.rutherfordscattering.RSConstants;
import edu.colorado.phet.rutherfordscattering.RSResources;
import edu.colorado.phet.rutherfordscattering.control.PlumPuddingAtomControlPanel;
import edu.colorado.phet.rutherfordscattering.model.Gun;
import edu.colorado.phet.rutherfordscattering.model.PlumPuddingAtom;
import edu.colorado.phet.rutherfordscattering.model.RSClock;
import edu.colorado.phet.rutherfordscattering.model.RSModel;
import edu.colorado.phet.rutherfordscattering.model.Space;
import edu.colorado.phet.rutherfordscattering.module.RSAbstractModule;
import edu.colorado.phet.rutherfordscattering.view.AnimationBoxNode;
import edu.colorado.phet.rutherfordscattering.view.BeamNode;
import edu.colorado.phet.rutherfordscattering.view.BoxLengthNode;
import edu.colorado.phet.rutherfordscattering.view.BoxOfAtomsNode;
import edu.colorado.phet.rutherfordscattering.view.GunNode;
import edu.colorado.phet.rutherfordscattering.view.PlumPuddingAtomNode;
import edu.colorado.phet.rutherfordscattering.view.TracesNode;
import edu.colorado.phet.rutherfordscattering.view.ZoomIndicatorNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

public class PlumPuddingAtomModule
extends RSAbstractModule {
    private RSModel _model;
    private Gun _gun;
    private PhetPCanvas _canvas;
    private PNode _rootNode;
    private PNode _boxBeamGunParent;
    private BoxOfAtomsNode _boxOfAtomsNode;
    private BeamNode _beamNode;
    private GunNode _gunNode;
    private AnimationBoxNode _animationBoxNode;
    private PNode _lengthNode;
    private ZoomIndicatorNode _zoomIndicatorNode;
    private TracesNode _alphaParticleTracesNode;
    private PiccoloClockControlPanel _clockControlPanel;
    private PlumPuddingAtomControlPanel _controlPanel;
    private boolean _wiggleMeInitialized = false;

    public PlumPuddingAtomModule() {
        super(RSResources.getString("string.plumPuddingAtom"), new RSClock(), false);
        IClock iClock = this.getClock();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d = Math.toRadians(-90.0);
        double d2 = RSConstants.ANIMATION_BOX_SIZE.width;
        this._gun = new Gun(double_, d, d2, RSConstants.INITIAL_SPEED_RANGE, RSConstants.BEAM_OF_ALPHA_PARTICLES_COLOR, RSConstants.ANIMATION_BOX_SIZE);
        double d3 = this._gun.getNozzleWidth();
        double d4 = RSConstants.ANIMATION_BOX_SIZE.height;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(-d3 / 2.0, -d4, d3, d4);
        Space space = new Space(double_2);
        Point2D point2D = space.getCenter();
        double d5 = 0.95 * (double)(RSConstants.ANIMATION_BOX_SIZE.width / 2);
        PlumPuddingAtom plumPuddingAtom = new PlumPuddingAtom(point2D, d5);
        this._model = new RSModel(iClock, this._gun, space, plumPuddingAtom);
        this._canvas = new PhetPCanvas(RSConstants.CANVAS_RENDERING_SIZE);
        this._canvas.setBackground(RSConstants.CANVAS_BACKGROUND);
        this.setSimulationPanel(this._canvas);
        this._rootNode = new PNode();
        this._canvas.addWorldChild(this._rootNode);
        this._boxBeamGunParent = new PNode();
        this._boxOfAtomsNode = new BoxOfAtomsNode(RSConstants.BOX_OF_HYDROGEN_SIZE, RSConstants.TINY_BOX_SIZE);
        this._beamNode = new BeamNode(RSConstants.BEAM_SIZE, this._model.getGun());
        this._gunNode = new GunNode(this._model.getGun());
        this._boxBeamGunParent.addChild(this._beamNode);
        this._boxBeamGunParent.addChild(this._boxOfAtomsNode);
        this._boxBeamGunParent.addChild(this._gunNode);
        double d6 = this._boxOfAtomsNode.getFullBounds().getWidth();
        double d7 = this._gunNode.getFullBounds().getWidth();
        if (d6 > d7) {
            this._boxOfAtomsNode.setOffset(0.0, 0.0);
            this._beamNode.setOffset((d6 - this._beamNode.getFullBounds().getWidth()) / 2.0, this._boxOfAtomsNode.getFullBounds().getMaxY());
            this._gunNode.setOffset((d6 - d7) / 2.0 + 20.0, this._beamNode.getFullBounds().getMaxY());
        } else {
            this._boxOfAtomsNode.setOffset((d7 - d6) / 2.0 - 20.0, 0.0);
            this._beamNode.setOffset(this._boxOfAtomsNode.getFullBounds().getX() + (d6 - this._beamNode.getFullBounds().getWidth()) / 2.0, this._boxOfAtomsNode.getFullBounds().getMaxY());
            this._gunNode.setOffset(0.0, this._beamNode.getFullBounds().getMaxY());
        }
        this._animationBoxNode = new AnimationBoxNode(this._model, RSConstants.ANIMATION_BOX_SIZE);
        String string = RSResources.getString("pattern.atomicScale");
        this._lengthNode = new BoxLengthNode(RSConstants.ANIMATION_BOX_SIZE.getWidth(), MessageFormat.format(string, 300.0), Color.WHITE);
        this._zoomIndicatorNode = new ZoomIndicatorNode();
        PlumPuddingAtomNode plumPuddingAtomNode = new PlumPuddingAtomNode(this._canvas, plumPuddingAtom);
        this._animationBoxNode.getAtomLayer().addChild(plumPuddingAtomNode);
        this._alphaParticleTracesNode = new TracesNode(this._model);
        this._alphaParticleTracesNode.setBounds(0.0, 0.0, this._animationBoxNode.getWidth(), this._animationBoxNode.getHeight());
        this._animationBoxNode.getTraceLayer().addChild(this._alphaParticleTracesNode);
        this._rootNode.addChild(this._boxBeamGunParent);
        this._rootNode.addChild(this._animationBoxNode);
        this._rootNode.addChild(this._zoomIndicatorNode);
        this._rootNode.addChild(this._lengthNode);
        this._clockControlPanel = new PiccoloClockControlPanel((RSClock)this.getClock());
        this.setClockControlPanel(this._clockControlPanel);
        this._controlPanel = new PlumPuddingAtomControlPanel(this);
        this.setControlPanel(this._controlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
        this.updateCanvasLayout();
    }

    public Gun getGun() {
        return this._gun;
    }

    public void removeAllAlphaParticles() {
        this._model.removeAllAlphaParticles();
    }

    public TracesNode getTracesNode() {
        return this._alphaParticleTracesNode;
    }

    public void reset() {
        IClock iClock = this.getClock();
        iClock.pause();
        this._model.removeAllAlphaParticles();
        this._gun.setEnabled(false);
        this._gun.setIntensity(1.0);
        this._gun.setSpeed(RSConstants.INITIAL_SPEED_RANGE.getDefault());
        this._controlPanel.setTracesEnabled(false);
        if (this.isActive()) {
            iClock.start();
        }
    }

    protected void updateCanvasLayout() {
        Dimension2D dimension2D = this._canvas.getWorldSize();
        if (dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0) {
            return;
        }
        double d = 40.0;
        double d2 = 250.0;
        this._boxBeamGunParent.setOffset(d, d2);
        d = this._boxBeamGunParent.getFullBounds().getMaxX() + 20.0;
        d2 = 40.0;
        this._animationBoxNode.setOffset(d, d2);
        this._lengthNode.setOffset(this._animationBoxNode.getXOffset(), this._animationBoxNode.getFullBoundsReference().getMaxY() + 10.0);
        Rectangle2D rectangle2D = this._zoomIndicatorNode.globalToLocal(this._boxOfAtomsNode.getTinyBoxGlobalFullBounds());
        Rectangle2D rectangle2D2 = this._zoomIndicatorNode.globalToLocal(this._animationBoxNode.getGlobalFullBounds());
        this._zoomIndicatorNode.update(rectangle2D, rectangle2D2);
        this.initWiggleMe();
    }

    private void initWiggleMe() {
        if (!this._wiggleMeInitialized) {
            // empty if block
        }
    }
}

