/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.view;

import edu.colorado.phet.rutherfordscattering.RSConstants;
import edu.colorado.phet.rutherfordscattering.event.ParticleEvent;
import edu.colorado.phet.rutherfordscattering.event.ParticleListener;
import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import edu.colorado.phet.rutherfordscattering.model.RSModel;
import edu.colorado.phet.rutherfordscattering.view.AlphaParticleNode;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public class AnimationBoxNode
extends PClip
implements ParticleListener {
    public static final Stroke STROKE = new BasicStroke(2.0f);
    public static final Color STROKE_COLOR = Color.WHITE;
    private PLayer _atomLayer;
    private PLayer _traceLayer;
    private PLayer _particleLayer;
    private PLayer _topLayer;
    private RSModel _model;
    private HashMap _particleMap;

    public AnimationBoxNode(RSModel rSModel, Dimension dimension) {
        this._model = rSModel;
        this._model.addParticleListener(this);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height);
        this.setPathTo(double_);
        this.setPaint(RSConstants.ANIMATION_BOX_COLOR);
        this.setStroke(STROKE);
        this.setStrokePaint(RSConstants.ANIMATION_BOX_STROKE_COLOR);
        this._atomLayer = new PLayer();
        this.addChild(this._atomLayer);
        this._traceLayer = new PLayer();
        this.addChild(this._traceLayer);
        this._particleLayer = new PLayer();
        this.addChild(this._particleLayer);
        this._topLayer = new PLayer();
        this.addChild(this._topLayer);
        this._particleMap = new HashMap();
    }

    public PLayer getAtomLayer() {
        return this._atomLayer;
    }

    public PLayer getTraceLayer() {
        return this._traceLayer;
    }

    public void particleAdded(ParticleEvent particleEvent) {
        AlphaParticle alphaParticle = particleEvent.getParticle();
        AlphaParticleNode alphaParticleNode = new AlphaParticleNode(alphaParticle);
        this._particleMap.put(alphaParticle, alphaParticleNode);
        this._particleLayer.addChild(alphaParticleNode);
    }

    public void particleRemoved(ParticleEvent particleEvent) {
        AlphaParticle alphaParticle = particleEvent.getParticle();
        AlphaParticleNode alphaParticleNode = (AlphaParticleNode)this._particleMap.get(alphaParticle);
        this._particleMap.remove(alphaParticle);
        this._particleLayer.removeChild(alphaParticleNode);
    }
}

