/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.rutherfordscattering.RSResources;
import edu.colorado.phet.rutherfordscattering.model.Gun;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public class GunNode
extends PhetPNode
implements Observer {
    private static final Point2D BUTTON_OFFSET = new Point2D.Double(36.0, 75.0);
    private Gun _gun;
    private PImage _onButton;
    private PImage _offButton;

    public GunNode(Gun gun) {
        this._gun = gun;
        PImage pImage = new PImage(RSResources.getImage("ray-gun.png"));
        this._onButton = new PImage(RSResources.getImage("gunOnButton.png"));
        this._offButton = new PImage(RSResources.getImage("gunOffButton.png"));
        this.addChild(pImage);
        this.addChild(this._onButton);
        this.addChild(this._offButton);
        pImage.setOffset(0.0, 0.0);
        this._onButton.setOffset(BUTTON_OFFSET);
        this._offButton.setOffset(BUTTON_OFFSET);
        pImage.setPickable(false);
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                GunNode.this._gun.setEnabled(!GunNode.this._gun.isEnabled());
            }
        };
        this._onButton.addInputEventListener(pBasicInputEventHandler);
        this._offButton.addInputEventListener(pBasicInputEventHandler);
        this._onButton.addInputEventListener(new CursorHandler());
        this._offButton.addInputEventListener(new CursorHandler());
        this.updateAll();
        this._gun.addObserver(this);
    }

    public PNode getButtonNode() {
        return this._offButton;
    }

    public void update(Observable observable, Object object) {
        if (observable == this._gun && object == "enabled") {
            this.updateAll();
        }
    }

    public void updateAll() {
        boolean bl = this._gun.isEnabled();
        this._onButton.setVisible(bl);
        this._onButton.setPickable(this._onButton.getVisible());
        this._offButton.setVisible(!bl);
        this._offButton.setPickable(this._offButton.getVisible());
    }
}

