/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.rutherfordscattering.model.RutherfordAtom;
import edu.colorado.phet.rutherfordscattering.view.ElectronNode;
import edu.colorado.phet.rutherfordscattering.view.NeutronNode;
import edu.colorado.phet.rutherfordscattering.view.ProtonNode;
import edu.colorado.phet.rutherfordscattering.view.RSModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;

public class RutherfordAtomNode
extends PhetPNode
implements Observer {
    private static final Color NUCLEUS_OUTLINE_COLOR = Color.GRAY;
    private static final Stroke NUCLEUS_OUTLINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{2.0f, 3.0f}, 0.0f);
    private static final Color ORBIT_COLOR = Color.GRAY;
    public static final Stroke ORBIT_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 6.0f}, 0.0f);
    private RutherfordAtom _atom;
    private PImage _nucleusNode;
    private PPath _nucleusOutlineNode;
    private ElectronNode _electronNode;
    private Random _randomDistance;
    private Random _randomAngle;
    private boolean _outlineModeEnabled;

    public RutherfordAtomNode(RutherfordAtom rutherfordAtom) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._atom = rutherfordAtom;
        this._atom.addObserver(this);
        this._nucleusNode = new PImage();
        this.addChild(this._nucleusNode);
        this._nucleusOutlineNode = new PPath();
        this._nucleusOutlineNode.setStroke(NUCLEUS_OUTLINE_STROKE);
        this._nucleusOutlineNode.setStrokePaint(NUCLEUS_OUTLINE_COLOR);
        this.addChild(this._nucleusOutlineNode);
        Point2D point2D = this._atom.getElectronOffsetRef();
        double d = Math.sqrt(point2D.getX() * point2D.getX() + point2D.getY() * point2D.getY());
        PPath pPath = RutherfordAtomNode.createOrbitNode(d);
        this.addChild(pPath);
        this._electronNode = new ElectronNode();
        this.addChild(this._electronNode);
        this._randomDistance = new Random();
        this._randomAngle = new Random(55L);
        this._outlineModeEnabled = false;
        Point2D point2D2 = rutherfordAtom.getPositionRef();
        Point2D point2D3 = RSModelViewTransform.transform(point2D2);
        this.setOffset(point2D3);
        this.updateNucleus();
        this.update(this._atom, "electronOffset");
    }

    private static PPath createOrbitNode(double d) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d, 2.0 * d, 2.0 * d);
        PPath pPath = new PPath();
        pPath.setPathTo(double_);
        pPath.setStroke(ORBIT_STROKE);
        pPath.setStrokePaint(ORBIT_COLOR);
        return pPath;
    }

    public void setOutlineModeEnabled(boolean bl) {
        if (bl != this._outlineModeEnabled) {
            this._outlineModeEnabled = bl;
            this.updateNucleus();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronOffset") {
                this.updateElectronOffset();
            } else if (object == "numberOfProtons" || object == "numberOfNeutrons") {
                this.updateNucleus();
            }
        }
    }

    private void updateElectronOffset() {
        Point2D point2D = this._atom.getElectronOffsetRef();
        double d = RSModelViewTransform.transform(point2D.getX());
        double d2 = RSModelViewTransform.transform(point2D.getY());
        this._electronNode.setOffset(d, d2);
    }

    private void updateNucleus() {
        int n = this._atom.getNumberOfProtons();
        int n2 = this._atom.getNumberOfNeutrons();
        int n3 = n + n2;
        int n4 = this._atom.getMinNumberOfProtons() + this._atom.getMinNumberOfNeutrons();
        double d = 20.0 / Math.pow(n4, 0.3333333333333333);
        double d2 = d * Math.pow(n3, 0.3333333333333333);
        assert (d2 > 0.0);
        this._nucleusNode.setVisible(!this._outlineModeEnabled);
        this._nucleusOutlineNode.setVisible(this._outlineModeEnabled);
        if (this._outlineModeEnabled) {
            this._nucleusOutlineNode.setPathTo(new Ellipse2D.Double(-d2, -d2, 2.0 * d2, 2.0 * d2));
        } else {
            double d3 = d2 - new ProtonNode().getDiameter() / 2.0;
            double d4 = d2 - new NeutronNode().getDiameter() / 2.0;
            PNode pNode = new PNode();
            for (int i = 0; i < Math.max(n, n2); ++i) {
                SphericalNode sphericalNode;
                double d5;
                double d6;
                double d7;
                double d8;
                if (i < n) {
                    d8 = d3 * Math.sqrt(this._randomDistance.nextDouble());
                    d7 = Math.PI * 2 * this._randomAngle.nextDouble();
                    d6 = d8 * Math.cos(d7);
                    d5 = d8 * Math.sin(d7);
                    sphericalNode = new ProtonNode();
                    sphericalNode.setOffset(d6, d5);
                    pNode.addChild(sphericalNode);
                }
                if (i >= n2) continue;
                d8 = d4 * Math.sqrt(this._randomDistance.nextDouble());
                d7 = Math.PI * 2 * this._randomAngle.nextDouble();
                d6 = d8 * Math.cos(d7);
                d5 = d8 * Math.sin(d7);
                sphericalNode = new NeutronNode();
                sphericalNode.setOffset(d6, d5);
                pNode.addChild(sphericalNode);
            }
            this._nucleusNode.setImage(pNode.toImage());
            this._nucleusNode.setOffset(-this._nucleusNode.getWidth() / 2.0, -this._nucleusNode.getHeight() / 2.0);
        }
    }
}

