/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model;

public class LjPotentialCalculator {
    private double m_sigma;
    private double m_epsilon;
    private double m_epsilonForCalcs;

    public LjPotentialCalculator(double d, double d2) {
        if (d == 0.0) {
            throw new IllegalArgumentException("Illegal value for the sigma parameter: " + d);
        }
        this.m_sigma = d;
        this.m_epsilon = d2;
        this.m_epsilonForCalcs = this.m_epsilon * 1.38E-23;
    }

    public double getSigma() {
        return this.m_sigma;
    }

    public void setSigma(double d) {
        this.m_sigma = d;
    }

    public double getEpsilon() {
        return this.m_epsilon;
    }

    public void setEpsilon(double d) {
        this.m_epsilon = d;
        this.m_epsilonForCalcs = d * 1.38E-23;
    }

    public double calculateLjPotential(double d) {
        double d2 = this.m_sigma / d;
        return 4.0 * this.m_epsilonForCalcs * (Math.pow(d2, 12.0) - Math.pow(d2, 6.0));
    }

    public double calculateRepulsiveLjForce(double d) {
        return 48.0 * this.m_epsilonForCalcs * Math.pow(this.m_sigma, 12.0) / Math.pow(d, 13.0);
    }

    public double calculateAttractiveLjForce(double d) {
        return 24.0 * this.m_epsilonForCalcs * Math.pow(this.m_sigma, 6.0) / Math.pow(d, 7.0);
    }

    public double calculateMinimumForceDistance() {
        return this.m_sigma * 1.122462;
    }

    public double calculatePotentialEnergy(double d) {
        return this.calculateLjPotential(d) - this.calculateLjPotential(this.calculateMinimumForceDistance());
    }
}

