/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.engine.WaterMoleculeStructure;
import java.awt.geom.Point2D;

public class MoleculeForceAndMotionDataSet {
    private int m_numberOfAtoms;
    private int m_numberOfSafeMolecules;
    private final int m_atomsPerMolecule;
    private double m_moleculeMass;
    private double m_moleculeRotationalInertia;
    private Point2D[] m_atomPositions;
    private Point2D[] m_moleculeCenterOfMassPositions;
    private Vector2D[] m_moleculeVelocities;
    private Vector2D[] m_moleculeForces;
    private Vector2D[] m_nextMoleculeForces;
    private double[] m_moleculeRotationAngles;
    private double[] m_moleculeRotationRates;
    private double[] m_moleculeTorques;
    private double[] m_nextMoleculeTorques;

    public MoleculeForceAndMotionDataSet(int n) {
        this.m_atomsPerMolecule = n;
        this.m_atomPositions = new Point2D[500];
        this.m_moleculeCenterOfMassPositions = new Point2D[500 / this.m_atomsPerMolecule];
        this.m_moleculeVelocities = new Vector2D[500 / this.m_atomsPerMolecule];
        this.m_moleculeForces = new Vector2D[500 / this.m_atomsPerMolecule];
        this.m_nextMoleculeForces = new Vector2D[500 / this.m_atomsPerMolecule];
        this.m_moleculeRotationAngles = new double[500 / this.m_atomsPerMolecule];
        this.m_moleculeRotationRates = new double[500 / this.m_atomsPerMolecule];
        this.m_moleculeTorques = new double[500 / this.m_atomsPerMolecule];
        this.m_nextMoleculeTorques = new double[500 / this.m_atomsPerMolecule];
        if (n == 1) {
            this.m_moleculeMass = 1.0;
        } else if (n == 2) {
            this.m_moleculeMass = 2.0;
            this.m_moleculeRotationalInertia = Math.pow(0.9, 2.0) / 2.0;
        } else if (n == 3) {
            this.m_moleculeMass = 1.5;
            this.m_moleculeRotationalInertia = WaterMoleculeStructure.getInstance().getRotationalInertia();
        }
    }

    public int getAtomsPerMolecule() {
        return this.m_atomsPerMolecule;
    }

    public Point2D[] getAtomPositions() {
        return this.m_atomPositions;
    }

    public int getNumberOfAtoms() {
        return this.m_numberOfAtoms;
    }

    public int getNumberOfMolecules() {
        return this.m_numberOfAtoms / this.m_atomsPerMolecule;
    }

    public int getNumberOfSafeMolecules() {
        return this.m_numberOfSafeMolecules;
    }

    public void setNumberOfSafeMolecules(int n) {
        this.m_numberOfSafeMolecules = n;
    }

    public Point2D[] getMoleculeCenterOfMassPositions() {
        return this.m_moleculeCenterOfMassPositions;
    }

    public Vector2D[] getMoleculeVelocities() {
        return this.m_moleculeVelocities;
    }

    public Vector2D[] getMoleculeForces() {
        return this.m_moleculeForces;
    }

    public Vector2D[] getNextMoleculeForces() {
        return this.m_nextMoleculeForces;
    }

    public double[] getMoleculeRotationAngles() {
        return this.m_moleculeRotationAngles;
    }

    public double[] getMoleculeRotationRates() {
        return this.m_moleculeRotationRates;
    }

    public double[] getMoleculeTorques() {
        return this.m_moleculeTorques;
    }

    public double[] getNextMoleculeTorques() {
        return this.m_nextMoleculeTorques;
    }

    public double getMoleculeMass() {
        return this.m_moleculeMass;
    }

    public double getMoleculeRotationalInertia() {
        return this.m_moleculeRotationalInertia;
    }

    public int getNumberOfRemainingSlots() {
        return 500 / this.m_atomsPerMolecule - this.m_numberOfAtoms / this.m_atomsPerMolecule;
    }

    public double calculateTemperatureFromKineticEnergy() {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.m_numberOfAtoms / this.m_atomsPerMolecule;
        if (this.m_atomsPerMolecule == 1) {
            for (int i = 0; i < this.m_numberOfAtoms; ++i) {
                d2 += (this.m_moleculeVelocities[i].getX() * this.m_moleculeVelocities[i].getX() + this.m_moleculeVelocities[i].getY() * this.m_moleculeVelocities[i].getY()) / 2.0;
            }
            d = d2 / (double)this.m_numberOfAtoms;
        } else {
            for (int i = 0; i < this.m_numberOfAtoms / this.m_atomsPerMolecule; ++i) {
                d2 += 0.5 * this.m_moleculeMass * (Math.pow(this.m_moleculeVelocities[i].getX(), 2.0) + Math.pow(this.m_moleculeVelocities[i].getY(), 2.0));
                d3 += 0.5 * this.m_moleculeRotationalInertia * Math.pow(this.m_moleculeRotationRates[i], 2.0);
            }
            d = (d2 + d3) / d4 / 1.5;
        }
        return d;
    }

    public boolean addMolecule(Point2D[] point2DArray, Point2D point2D, Vector2D vector2D, double d) {
        if (this.getNumberOfRemainingSlots() == 0) {
            return false;
        }
        System.arraycopy(point2DArray, 0, this.m_atomPositions, 0 + this.m_numberOfAtoms, this.m_atomsPerMolecule);
        int n = this.m_numberOfAtoms / this.m_atomsPerMolecule;
        this.m_moleculeCenterOfMassPositions[n] = point2D;
        this.m_moleculeVelocities[n] = vector2D;
        this.m_moleculeRotationRates[n] = d;
        this.m_moleculeForces[n] = new Vector2D();
        this.m_nextMoleculeForces[n] = new Vector2D();
        this.m_numberOfAtoms += this.m_atomsPerMolecule;
        return true;
    }

    public void removeMolecule(int n) {
        int n2;
        if (n >= this.m_numberOfAtoms / this.m_atomsPerMolecule) {
            return;
        }
        for (n2 = n; n2 < this.m_numberOfAtoms / this.m_atomsPerMolecule - 1; ++n2) {
            this.m_moleculeCenterOfMassPositions[n2] = this.m_moleculeCenterOfMassPositions[n2 + 1];
            this.m_moleculeVelocities[n2] = this.m_moleculeVelocities[n2 + 1];
            this.m_moleculeForces[n2] = this.m_moleculeForces[n2 + 1];
            this.m_nextMoleculeForces[n2] = this.m_nextMoleculeForces[n2 + 1];
            this.m_moleculeRotationAngles[n2] = this.m_moleculeRotationAngles[n2 + 1];
            this.m_moleculeRotationRates[n2] = this.m_moleculeRotationRates[n2 + 1];
            this.m_moleculeTorques[n2] = this.m_moleculeTorques[n2 + 1];
            this.m_nextMoleculeTorques[n2] = this.m_nextMoleculeTorques[n2 + 1];
        }
        for (n2 = n * this.m_atomsPerMolecule; n2 < this.m_numberOfAtoms - this.m_atomsPerMolecule; n2 += this.m_atomsPerMolecule) {
            System.arraycopy(this.m_atomPositions, n2 + this.m_atomsPerMolecule + 0, this.m_atomPositions, n2 + 0, this.m_atomsPerMolecule);
        }
        this.m_numberOfAtoms -= this.m_atomsPerMolecule;
    }
}

