/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.WaterMoleculeStructure;
import java.awt.geom.Point2D;

public class WaterAtomPositionUpdater
implements AtomPositionUpdater {
    final double[] structureX = WaterMoleculeStructure.getInstance().getStructureArrayX();
    final double[] structureY = WaterMoleculeStructure.getInstance().getStructureArrayY();

    public void updateAtomPositions(MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        assert (moleculeForceAndMotionDataSet.getAtomsPerMolecule() == 3);
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getAtomPositions();
        Point2D[] point2DArray2 = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        for (n = 0; n < moleculeForceAndMotionDataSet.getNumberOfMolecules(); ++n) {
            d4 = Math.cos(dArray[n]);
            d3 = Math.sin(dArray[n]);
            d2 = point2DArray2[n].getX() + d4 * 0.45;
            d = point2DArray2[n].getY() + d3 * 0.45;
            point2DArray[n * 2].setLocation(d2, d);
            d2 = point2DArray2[n].getX() - d4 * 0.45;
            d = point2DArray2[n].getY() - d3 * 0.45;
            point2DArray[n * 2 + 1].setLocation(d2, d);
        }
        for (n = 0; n < moleculeForceAndMotionDataSet.getNumberOfMolecules(); ++n) {
            d4 = Math.cos(dArray[n]);
            d3 = Math.sin(dArray[n]);
            for (int i = 0; i < 3; ++i) {
                d2 = point2DArray2[n].getX() + d4 * this.structureX[i] - d3 * this.structureY[i];
                d = point2DArray2[n].getY() + d3 * this.structureX[i] + d4 * this.structureY[i];
                point2DArray[n * 3 + i].setLocation(d2, d);
            }
        }
    }
}

