/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

public class WaterMoleculeStructure {
    private static WaterMoleculeStructure instance;
    final double[] m_moleculeStructureX = new double[3];
    final double[] m_moleculeStructureY = new double[3];

    private WaterMoleculeStructure() {
        this.m_moleculeStructureX[0] = 0.0;
        this.m_moleculeStructureY[0] = 0.0;
        this.m_moleculeStructureX[1] = 0.3205128205128205;
        this.m_moleculeStructureY[1] = 0.0;
        this.m_moleculeStructureX[2] = 0.3205128205128205 * Math.cos(2.0943951023931953);
        this.m_moleculeStructureY[2] = 0.3205128205128205 * Math.sin(2.0943951023931953);
        double d = (this.m_moleculeStructureX[0] + 0.25 * this.m_moleculeStructureX[1] + 0.25 * this.m_moleculeStructureX[2]) / 1.5;
        double d2 = (this.m_moleculeStructureY[0] + 0.25 * this.m_moleculeStructureY[1] + 0.25 * this.m_moleculeStructureY[2]) / 1.5;
        int n = 0;
        while (n < 3) {
            int n2 = n;
            this.m_moleculeStructureX[n2] = this.m_moleculeStructureX[n2] - d;
            int n3 = n++;
            this.m_moleculeStructureY[n3] = this.m_moleculeStructureY[n3] - d2;
        }
    }

    public static WaterMoleculeStructure getInstance() {
        if (instance == null) {
            instance = new WaterMoleculeStructure();
        }
        return instance;
    }

    public double[] getStructureArrayX() {
        return this.m_moleculeStructureX;
    }

    public double[] getStructureArrayY() {
        return this.m_moleculeStructureY;
    }

    public double getRotationalInertia() {
        return Math.pow(this.m_moleculeStructureX[0], 2.0) + Math.pow(this.m_moleculeStructureY[0], 2.0) + 0.25 * (Math.pow(this.m_moleculeStructureX[1], 2.0) + Math.pow(this.m_moleculeStructureY[1], 2.0)) + 0.25 * (Math.pow(this.m_moleculeStructureX[2], 2.0) + Math.pow(this.m_moleculeStructureY[2], 2.0));
    }
}

