/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.particle;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.AtomType;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class StatesOfMatterAtom
implements Cloneable {
    private Point2D.Double m_position = new Point2D.Double();
    private Vector2D m_velocity = new Vector2D();
    private Vector2D m_accel = new Vector2D();
    protected double m_radius;
    private final double m_mass;
    private final ArrayList m_listeners = new ArrayList();

    public StatesOfMatterAtom(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 0.0, 0.0, 0.0, 0.0);
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Mass is out of range");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Radius is out of range");
        }
    }

    public abstract AtomType getType();

    public double getX() {
        return this.m_position.x;
    }

    public double getY() {
        return this.m_position.y;
    }

    public void setPosition(double d, double d2) {
        this.m_position.x = d;
        this.m_position.y = d2;
        this.notifyPositionChanged();
    }

    public double getVy() {
        return this.m_velocity.getY();
    }

    public double getVx() {
        return this.m_velocity.getX();
    }

    public void setVx(double d) {
        this.m_velocity.setX(d);
        this.notifyVelocityChanged();
    }

    public double getAx() {
        return this.m_accel.getX();
    }

    public double getAy() {
        return this.m_accel.getY();
    }

    public void setAx(double d) {
        this.m_accel.setX(d);
        this.notifyAccelerationChanged();
    }

    public double getMass() {
        return this.m_mass;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public Point2D getPositionReference() {
        return this.m_position;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StatesOfMatterAtom statesOfMatterAtom = (StatesOfMatterAtom)object;
        if (Double.compare(statesOfMatterAtom.m_mass, this.m_mass) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.m_radius, this.m_radius) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.getVx(), this.getVx()) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.getVy(), this.getVy()) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.getX(), this.getX()) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.getY(), this.getY()) != 0) {
            return false;
        }
        if (Double.compare(statesOfMatterAtom.getAx(), this.getAx()) != 0) {
            return false;
        }
        return Double.compare(statesOfMatterAtom.getAy(), this.getAy()) == 0;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            StatesOfMatterAtom statesOfMatterAtom = (StatesOfMatterAtom)super.clone();
            statesOfMatterAtom.m_position = new Point2D.Double(this.getX(), this.getY());
            statesOfMatterAtom.m_velocity = new Vector2D(this.getVx(), this.getVy());
            statesOfMatterAtom.m_accel = new Vector2D(this.getAx(), this.getAy());
            return statesOfMatterAtom;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.getX() + ",y=" + this.getY() + ",radius=" + this.m_radius + ",mass=" + this.m_mass + ",vx=" + this.getVx() + ",vy=" + this.getVy() + ",ax=" + this.getAx() + ",ay=" + this.getAy() + "]";
    }

    public void addListener(Listener listener) {
        if (this.m_listeners.contains(listener)) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.m_listeners.remove(listener);
    }

    public void removedFromModel() {
        this.notifyParticleRemoved();
        this.m_listeners.clear();
    }

    private StatesOfMatterAtom(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.m_position.setLocation(d, d2);
        this.m_velocity.setComponents(d5, d6);
        this.m_accel.setComponents(d7, d8);
        this.m_mass = d4;
        this.m_radius = d3;
    }

    private void notifyPositionChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).positionChanged();
        }
    }

    private void notifyVelocityChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).velocityChanged();
        }
    }

    private void notifyAccelerationChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).accelerationChanged();
        }
    }

    private void notifyParticleRemoved() {
        for (Object e : this.m_listeners) {
            ((Listener)e).particleRemoved(this);
        }
    }

    protected void notifyRadiusChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).radiusChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void velocityChanged() {
        }

        public void accelerationChanged() {
        }

        public void particleRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void radiusChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void velocityChanged();

        public void accelerationChanged();

        public void particleRemoved(StatesOfMatterAtom var1);

        public void radiusChanged();
    }
}

