/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.LjPotentialCalculator;
import edu.colorado.phet.statesofmatter.module.CloseRequestListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class InteractionPotentialDiagramNode
extends PNode {
    private static final Stroke AXIS_LINE_STROKE = new BasicStroke(1.0f);
    private static final Color AXIS_LINE_COLOR = Color.BLACK;
    private static final Stroke POTENTIAL_ENERGY_LINE_STROKE = new BasicStroke(1.5f);
    private static final Color POTENTIAL_ENERGY_LINE_COLOR = Color.red;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final Color POSITION_MARKER_COLOR = Color.CYAN;
    private static final Stroke POSITION_MARKER_STROKE = new BasicStroke(0.75f);
    private static final Color CENTER_AXIS_LINE_COLOR = Color.LIGHT_GRAY;
    private static final Font AXIS_LABEL_FONT = new PhetFont(14);
    private static final Font GREEK_LETTER_FONT = new PhetFont(16);
    protected final double m_width;
    protected final double m_height;
    private double m_sigma;
    private double m_epsilon;
    private final double m_graphXOrigin;
    private final double m_graphYOrigin;
    private final double m_graphWidth;
    private final double m_graphHeight;
    private final PPath m_background;
    private final PPath m_potentialEnergyLine;
    private final DoubleArrowNode m_epsilonArrow;
    private final PText m_epsilonLabel;
    private final PText m_sigmaLabel;
    private final DoubleArrowNode m_sigmaArrow;
    private final double m_verticalScalingFactor;
    private final Point2D m_graphMin;
    private final Point2D m_zeroCrossingPoint;
    private double m_markerDistance;
    private final PText m_horizontalAxisLabel;
    private final LjPotentialCalculator m_LjPotentialCalculator;
    private final ArrayList _listeners = new ArrayList();
    protected final PNode m_markerLayer;
    protected final PPath m_positionMarker;
    private boolean m_positionMarkerEnabled;
    protected final PPath m_ljPotentialGraph;

    public InteractionPotentialDiagramNode(double d, double d2, boolean bl, boolean bl2) {
        PNode pNode;
        Serializable serializable;
        this.m_sigma = d;
        this.m_epsilon = d2;
        this.m_positionMarkerEnabled = false;
        this.m_graphMin = new Point2D.Double(0.0, 0.0);
        this.m_zeroCrossingPoint = new Point2D.Double(0.0, 0.0);
        this.m_markerDistance = 0.0;
        this.m_LjPotentialCalculator = new LjPotentialCalculator(this.m_sigma, this.m_epsilon);
        if (bl) {
            this.m_width = 300.0;
            this.m_height = this.m_width * 0.6;
        } else {
            this.m_width = 200.0;
            this.m_height = this.m_width * 0.8;
        }
        this.m_graphXOrigin = 0.1 * this.m_width;
        this.m_graphYOrigin = 0.85 * this.m_height;
        this.m_graphWidth = this.m_width - this.m_graphXOrigin - 8.0;
        this.m_graphHeight = bl2 ? this.m_height * 0.74 : this.m_height * 0.85 - 8.0;
        this.m_verticalScalingFactor = this.m_graphHeight / 2.0 / 6.21E-21;
        this.m_background = new PPath(new Rectangle2D.Double(0.0, 0.0, this.m_width, this.m_height));
        this.m_background.setPaint(DEFAULT_BACKGROUND_COLOR);
        this.addChild(this.m_background);
        this.m_ljPotentialGraph = new PPath(new Rectangle2D.Double(0.0, 0.0, this.m_graphWidth, this.m_graphHeight));
        this.m_ljPotentialGraph.setOffset(this.m_graphXOrigin, this.m_graphYOrigin - this.m_graphHeight);
        this.m_ljPotentialGraph.setPaint(Color.WHITE);
        this.m_ljPotentialGraph.setStrokePaint(Color.WHITE);
        this.addChild(this.m_ljPotentialGraph);
        PPath pPath = new PPath(new Line2D.Double(new Point2D.Double(0.0, 0.0), new Point2D.Double(this.m_graphWidth, 0.0)));
        pPath.setStroke(AXIS_LINE_STROKE);
        pPath.setStrokePaint(CENTER_AXIS_LINE_COLOR);
        this.m_ljPotentialGraph.addChild(pPath);
        pPath.setOffset(0.0, this.m_graphHeight / 2.0);
        this.m_potentialEnergyLine = new PPath(){

            public void paint(PPaintContext pPaintContext) {
                Graphics2D graphics2D = pPaintContext.getGraphics();
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                super.paint(pPaintContext);
                graphics2D.setRenderingHints(renderingHints);
            }
        };
        this.m_potentialEnergyLine.setStroke(POTENTIAL_ENERGY_LINE_STROKE);
        this.m_potentialEnergyLine.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
        this.m_ljPotentialGraph.addChild(this.m_potentialEnergyLine);
        this.m_epsilonArrow = new DoubleArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, this.m_graphHeight / 2.0), 4.0, 4.0, 0.5);
        this.m_epsilonArrow.setPaint(Color.BLACK);
        this.m_ljPotentialGraph.addChild(this.m_epsilonArrow);
        this.m_epsilonLabel = new PText("\u03b5");
        this.m_epsilonLabel.setFont(GREEK_LETTER_FONT);
        this.m_ljPotentialGraph.addChild(this.m_epsilonLabel);
        this.m_sigmaLabel = new PText("\u03c3");
        this.m_sigmaLabel.setFont(GREEK_LETTER_FONT);
        this.m_ljPotentialGraph.addChild(this.m_sigmaLabel);
        this.m_sigmaArrow = new DoubleArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 4.0, 4.0, 0.5);
        this.m_sigmaArrow.setPaint(Color.BLACK);
        this.m_ljPotentialGraph.addChild(this.m_sigmaArrow);
        this.m_markerLayer = new PNode();
        this.m_markerLayer.setOffset(this.m_graphXOrigin, this.m_graphYOrigin - this.m_graphHeight);
        this.addChild(this.m_markerLayer);
        GeneralPath generalPath = new GeneralPath();
        double d3 = 0.03 * this.m_graphWidth;
        generalPath.append(new Ellipse2D.Double(0.0, 0.0, d3, d3), false);
        this.m_positionMarker = new PPath(generalPath);
        this.m_positionMarker.setStroke(POSITION_MARKER_STROKE);
        this.m_positionMarker.setPaint(POSITION_MARKER_COLOR);
        this.m_positionMarker.setVisible(this.m_positionMarkerEnabled);
        this.m_markerLayer.addChild(this.m_positionMarker);
        if (bl2) {
            serializable = new JButton(new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png")));
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InteractionPotentialDiagramNode.this.notifyCloseRequestReceived();
                }
            });
            pNode = new PSwing((JComponent)serializable);
            pNode.setScale(this.getFullBoundsReference().height * 0.11 / pNode.getFullBoundsReference().height);
            pNode.setOffset(this.m_width - pNode.getFullBoundsReference().width, 0.0);
            this.addChild(pNode);
        }
        serializable = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(this.m_graphWidth + 8.0, 0.0), 8.0, 5.0, 1.0);
        ((PPath)serializable).setStroke(AXIS_LINE_STROKE);
        ((PNode)serializable).setPaint(AXIS_LINE_COLOR);
        ((PPath)serializable).setStrokePaint(AXIS_LINE_COLOR);
        ((PNode)serializable).setOffset(this.m_graphXOrigin, this.m_graphYOrigin);
        this.addChild((PNode)serializable);
        this.m_horizontalAxisLabel = new PText(StatesOfMatterStrings.INTERACTION_POTENTIAL_GRAPH_X_AXIS_LABEL_ATOMS);
        this.m_horizontalAxisLabel.setFont(AXIS_LABEL_FONT);
        this.addChild(this.m_horizontalAxisLabel);
        this.setMolecular(false);
        pNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, -this.m_graphHeight - 8.0), 8.0, 5.0, 1.0);
        ((PPath)pNode).setStroke(AXIS_LINE_STROKE);
        pNode.setPaint(AXIS_LINE_COLOR);
        ((PPath)pNode).setStrokePaint(AXIS_LINE_COLOR);
        pNode.setOffset(this.m_graphXOrigin, this.m_graphYOrigin);
        this.addChild(pNode);
        PText pText = new PText(StatesOfMatterStrings.INTERACTION_POTENTIAL_GRAPH_Y_AXIS_LABEL);
        pText.setFont(AXIS_LABEL_FONT);
        pText.setOffset(this.m_graphXOrigin / 2.0 - pText.getFullBoundsReference().height / 2.0, this.m_graphYOrigin - this.m_graphHeight / 2.0 + pText.getFullBoundsReference().width / 2.0);
        pText.rotate(4.71238898038469);
        this.addChild(pText);
        this.drawPotentialCurve();
    }

    public void setLjPotentialParameters(double d, double d2) {
        this.m_sigma = d;
        this.m_epsilon = d2;
        this.m_LjPotentialCalculator.setEpsilon(this.m_epsilon);
        this.m_LjPotentialCalculator.setSigma(this.m_sigma);
        this.drawPotentialCurve();
    }

    public void addListener(CloseRequestListener closeRequestListener) {
        if (!this._listeners.contains(closeRequestListener)) {
            this._listeners.add(closeRequestListener);
        }
    }

    protected double getGraphHeight() {
        return this.m_graphHeight;
    }

    protected double getGraphWidth() {
        return this.m_graphWidth;
    }

    protected Point2D getZeroCrossingPoint() {
        return this.m_zeroCrossingPoint;
    }

    protected Point2D getGraphMin() {
        return this.m_graphMin;
    }

    public void setMarkerEnabled(boolean bl) {
        this.m_positionMarkerEnabled = bl;
    }

    public void setMarkerPosition(double d) {
        this.m_markerDistance = d;
        double d2 = this.m_markerDistance * (this.m_graphWidth / 1200.0);
        double d3 = this.calculateLennardJonesPotential(this.m_markerDistance);
        double d4 = this.m_graphHeight / 2.0 - d3 * this.m_verticalScalingFactor;
        if (this.m_positionMarkerEnabled && d2 > 0.0 && d2 < this.m_graphWidth && d4 > 0.0 && d4 < this.m_graphHeight) {
            this.m_positionMarker.setVisible(true);
            this.m_positionMarker.setOffset(d2 - this.m_positionMarker.getFullBoundsReference().width / 2.0, d4 - this.m_positionMarker.getFullBoundsReference().getHeight() / 2.0);
        } else {
            this.m_positionMarker.setVisible(false);
        }
    }

    public double getXAxisRange() {
        return 1200.0;
    }

    public double getXAxisGraphProportion() {
        return this.m_graphWidth / this.m_width;
    }

    public double getXAxisOffsetProportion() {
        return 1.0 - (this.m_graphWidth + 8.0) / this.m_width;
    }

    public void setMolecular(boolean bl) {
        if (bl) {
            this.m_horizontalAxisLabel.setText(StatesOfMatterStrings.INTERACTION_POTENTIAL_GRAPH_X_AXIS_LABEL_MOLECULES);
        } else {
            this.m_horizontalAxisLabel.setText(StatesOfMatterStrings.INTERACTION_POTENTIAL_GRAPH_X_AXIS_LABEL_ATOMS);
        }
        this.m_horizontalAxisLabel.setOffset(this.m_graphXOrigin + this.m_graphWidth / 2.0 - this.m_horizontalAxisLabel.getFullBoundsReference().width / 2.0, this.m_graphYOrigin + this.m_horizontalAxisLabel.getFullBoundsReference().height * 0.3);
    }

    public void setBackgroundColor(Color color) {
        this.m_background.setPaint(color);
        this.m_background.setStrokePaint(color);
    }

    private double calculateLennardJonesPotential(double d) {
        return this.m_LjPotentialCalculator.calculateLjPotential(d);
    }

    protected void drawPotentialCurve() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        this.m_graphMin.setLocation(0.0, 0.0);
        this.m_zeroCrossingPoint.setLocation(0.0, 0.0);
        double d = 1200.0 / this.m_graphWidth;
        for (int i = 1; i < (int)this.m_graphWidth; ++i) {
            double d2 = this.calculateLennardJonesPotential((double)i * d);
            double d3 = this.m_graphHeight / 2.0 - d2 * this.m_verticalScalingFactor;
            if (d3 > 0.0 && d3 < this.m_graphHeight) {
                generalPath.lineTo(i, (float)d3);
                if (d3 > this.m_graphMin.getY()) {
                    this.m_graphMin.setLocation(i, d3);
                }
                if (!(d2 > 0.0) && this.m_zeroCrossingPoint.getX() != 0.0) continue;
                this.m_zeroCrossingPoint.setLocation(i, this.m_graphHeight / 2.0);
                continue;
            }
            generalPath.moveTo(i + 1, 0.0f);
        }
        this.m_potentialEnergyLine.setPathTo(generalPath);
        Point2D.Double double_ = new Point2D.Double(this.m_graphMin.getX(), this.m_graphHeight / 2.0);
        if (double_.distance(this.m_graphMin) > this.m_epsilonArrow.getHeadHeight() * 2.0) {
            this.m_epsilonArrow.setVisible(true);
            try {
                this.m_epsilonArrow.setTipAndTailLocations(this.m_graphMin, double_);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Error: Caught exception while positioning epsilon arrow - " + runtimeException);
            }
        } else {
            this.m_epsilonArrow.setVisible(false);
        }
        this.m_epsilonLabel.setOffset(this.m_graphMin.getX() + this.m_epsilonLabel.getFullBoundsReference().width * 0.5, (this.m_graphMin.getY() - this.m_graphHeight / 2.0) / 3.0 - this.m_epsilonLabel.getFullBoundsReference().height / 2.0 + this.m_graphHeight / 2.0);
        this.m_sigmaLabel.setOffset(this.m_zeroCrossingPoint.getX() / 2.0 - this.m_sigmaLabel.getFullBoundsReference().width / 2.0, this.m_graphHeight / 2.0);
        try {
            this.m_sigmaArrow.setTipAndTailLocations(new Point2D.Double(0.0, this.m_graphHeight / 2.0), this.m_zeroCrossingPoint);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Error: Caught exception while positioning sigma arrow - " + runtimeException);
        }
        this.setMarkerPosition(this.m_markerDistance);
    }

    private void notifyCloseRequestReceived() {
        for (Object e : this._listeners) {
            ((CloseRequestListener)e).closeRequestReceived();
        }
    }
}

