/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.atomicinteractions;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.help.DefaultWiggleMe;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterGlobalState;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.DualAtomModel;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.module.InteractionPotentialDiagramNode;
import edu.colorado.phet.statesofmatter.module.atomicinteractions.InteractiveInteractionPotentialDiagram;
import edu.colorado.phet.statesofmatter.view.GrabbableParticleNode;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleForceNode;
import edu.colorado.phet.statesofmatter.view.PushpinNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class AtomicInteractionsCanvas
extends PhetPCanvas {
    private final DualAtomModel m_model;
    private final ModelViewTransform m_mvt;
    private StatesOfMatterAtom m_fixedParticle;
    private StatesOfMatterAtom m_movableParticle;
    private ParticleForceNode m_fixedParticleNode;
    private GrabbableParticleNode m_movableParticleNode;
    private final InteractionPotentialDiagramNode m_interactionPotentialDiagram;
    private final StatesOfMatterAtom.Listener m_atomListener;
    private boolean m_showAttractiveForces;
    private boolean m_showRepulsiveForces;
    private boolean m_showTotalForces;
    private final HTMLImageButtonNode m_retrieveAtomButtonNode;
    private DefaultWiggleMe m_wiggleMe;
    private boolean m_wiggleMeShown;
    private final PushpinNode m_pushPinNode;
    private final PNode m_fixedParticleLayer;
    private final PNode m_movableParticleLayer;

    public AtomicInteractionsCanvas(DualAtomModel dualAtomModel) {
        this.m_model = dualAtomModel;
        this.m_showAttractiveForces = false;
        this.m_showRepulsiveForces = false;
        this.m_showTotalForces = false;
        this.m_wiggleMeShown = false;
        this.m_movableParticle = this.m_model.getMovableAtomRef();
        this.m_fixedParticle = this.m_model.getFixedAtomRef();
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(2000.0, 1500.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)AtomicInteractionsCanvas.this.getWidth() * 0.3, (double)AtomicInteractionsCanvas.this.getHeight() * 0.78);
            }
        });
        this.m_mvt = new ModelViewTransform(1.0, 1.0, 0.0, 0.0, false, true);
        StatesOfMatterGlobalState.whiteBackground.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    AtomicInteractionsCanvas.this.setBackground(Color.WHITE);
                } else {
                    AtomicInteractionsCanvas.this.setBackground(StatesOfMatterConstants.CANVAS_BACKGROUND);
                }
            }
        });
        this.m_model.addListener(new DualAtomModel.Adapter(){

            public void fixedAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsCanvas.this.handleFixedParticleAdded(statesOfMatterAtom);
            }

            public void fixedAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsCanvas.this.handleFixedParticleRemoved(statesOfMatterAtom);
            }

            public void movableAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsCanvas.this.handleMovableParticleAdded(statesOfMatterAtom);
            }

            public void movableAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsCanvas.this.handleMovableParticleRemoved(statesOfMatterAtom);
            }

            public void movableAtomDiameterChanged() {
                AtomicInteractionsCanvas.this.updateMinimumXForMovableAtom();
            }

            public void fixedAtomDiameterChanged() {
                AtomicInteractionsCanvas.this.updateMinimumXForMovableAtom();
            }
        });
        this.m_atomListener = new StatesOfMatterAtom.Adapter(){

            public void positionChanged() {
                AtomicInteractionsCanvas.this.handlePositionChanged();
            }

            public void radiusChanged() {
                AtomicInteractionsCanvas.this.handleParticleRadiusChanged();
            }
        };
        this.m_interactionPotentialDiagram = new InteractiveInteractionPotentialDiagram(this.m_model.getSigma(), this.m_model.getEpsilon(), true, this.m_model);
        double d = this.m_interactionPotentialDiagram.getXAxisRange() / this.m_interactionPotentialDiagram.getXAxisGraphProportion();
        double d2 = d / this.m_interactionPotentialDiagram.getFullBoundsReference().width;
        this.m_interactionPotentialDiagram.scale(d2);
        this.m_interactionPotentialDiagram.setOffset(-this.m_interactionPotentialDiagram.getFullBoundsReference().width * this.m_interactionPotentialDiagram.getXAxisOffsetProportion(), -this.m_interactionPotentialDiagram.getFullBoundsReference().height * 1.3);
        this.addWorldChild(this.m_interactionPotentialDiagram);
        this.m_retrieveAtomButtonNode = new HTMLImageButtonNode(StatesOfMatterStrings.RETRIEVE_ATOM, new PhetFont(1, 16), new Color(0xFFCC66));
        this.m_retrieveAtomButtonNode.scale(120.0 / this.m_retrieveAtomButtonNode.getFullBoundsReference().height);
        this.m_retrieveAtomButtonNode.setVisible(false);
        this.addWorldChild(this.m_retrieveAtomButtonNode);
        this.m_retrieveAtomButtonNode.setOffset(this.m_interactionPotentialDiagram.getFullBoundsReference().getMaxX() - this.m_retrieveAtomButtonNode.getFullBoundsReference().width, 183.33333333333334);
        this.m_retrieveAtomButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AtomicInteractionsCanvas.this.m_model.resetMovableAtomPos();
            }
        });
        this.m_pushPinNode = new PushpinNode();
        this.m_pushPinNode.scale(200.0 / this.m_pushPinNode.getFullBoundsReference().width);
        this.m_movableParticleLayer = new PNode();
        this.addWorldChild(this.m_movableParticleLayer);
        this.m_fixedParticleLayer = new PNode();
        this.addWorldChild(this.m_fixedParticleLayer);
        if (this.m_movableParticle != null) {
            this.handleMovableParticleAdded(this.m_movableParticle);
        }
        if (this.m_fixedParticle != null) {
            this.handleFixedParticleAdded(this.m_fixedParticle);
        }
    }

    public void setShowAttractiveForces(boolean bl) {
        this.m_movableParticleNode.setShowAttractiveForces(bl);
        this.m_fixedParticleNode.setShowAttractiveForces(bl);
        this.m_showAttractiveForces = bl;
    }

    public void setShowRepulsiveForces(boolean bl) {
        this.m_movableParticleNode.setShowRepulsiveForces(bl);
        this.m_fixedParticleNode.setShowRepulsiveForces(bl);
        this.m_showRepulsiveForces = bl;
    }

    public void setShowTotalForces(boolean bl) {
        this.m_movableParticleNode.setShowTotalForces(bl);
        this.m_fixedParticleNode.setShowTotalForces(bl);
        this.m_showTotalForces = bl;
    }

    protected void updateLayout() {
        if (this.getWorldSize().getWidth() <= 0.0 || this.getWorldSize().getHeight() <= 0.0) {
            return;
        }
        if (!this.m_wiggleMeShown) {
            this.m_wiggleMe = new DefaultWiggleMe(this, StatesOfMatterStrings.WIGGLE_ME_CAPTION);
            this.m_wiggleMe.setArrowTailPosition(MotionHelpBalloon.LEFT_CENTER);
            this.m_wiggleMe.setTextColor(Color.YELLOW);
            this.m_wiggleMe.setArrowFillPaint(Color.YELLOW);
            this.m_wiggleMe.setArrowStrokePaint(Color.YELLOW);
            this.m_wiggleMe.setBalloonFillPaint(new Color(0, 0, 0, 0));
            this.m_wiggleMe.setBalloonStrokePaint(new Color(0, 0, 0, 0));
            double d = 90.0 / this.m_wiggleMe.getFullBoundsReference().height;
            this.m_wiggleMe.scale(d);
            this.addWorldChild(this.m_wiggleMe);
            Rectangle rectangle = this.getBounds();
            Point2D.Double double_ = new Point2D.Double(rectangle.getMaxX(), 0.0);
            this.getPhetRootNode().screenToWorld(double_);
            ((Point2D)double_).setLocation(((Point2D)double_).getX(), 0.0);
            this.m_wiggleMe.setOffset(((Point2D)double_).getX(), this.m_model.getMovableAtomRef().getY());
            this.m_wiggleMe.animateToPositionScaleRotation(this.m_model.getMovableAtomRef().getX() + this.m_model.getMovableAtomRef().getRadius(), this.m_model.getMovableAtomRef().getY(), d, 0.0, 2000L);
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    AtomicInteractionsCanvas.this.clearWiggleMe();
                    AtomicInteractionsCanvas.this.removeInputEventListener(this);
                }
            });
            this.m_wiggleMeShown = true;
        }
    }

    private void handleFixedParticleAdded(StatesOfMatterAtom statesOfMatterAtom) {
        this.m_fixedParticle = statesOfMatterAtom;
        this.m_fixedParticleNode = new ParticleForceNode(statesOfMatterAtom, this.m_mvt, true, true);
        this.m_fixedParticleNode.setShowAttractiveForces(this.m_showAttractiveForces);
        this.m_fixedParticleNode.setShowRepulsiveForces(this.m_showRepulsiveForces);
        this.m_fixedParticleNode.setShowTotalForces(this.m_showTotalForces);
        this.m_fixedParticleLayer.addChild(this.m_fixedParticleNode);
        statesOfMatterAtom.addListener(this.m_atomListener);
        this.updatePositionMarkerOnDiagram();
        this.addWorldChild(this.m_pushPinNode);
        this.m_pushPinNode.setOffset(this.m_fixedParticle.getRadius() * 0.25, this.m_fixedParticle.getRadius() * 0.1);
    }

    private void handleFixedParticleRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        if (this.m_fixedParticleNode != null) {
            this.m_fixedParticleLayer.removeChild(this.m_fixedParticleNode);
            this.removeWorldChild(this.m_pushPinNode);
        } else {
            System.err.println("Error: Problem encountered removing node from canvas.");
        }
        statesOfMatterAtom.removeListener(this.m_atomListener);
        this.updatePositionMarkerOnDiagram();
        this.m_fixedParticleNode = null;
    }

    private void handleMovableParticleAdded(StatesOfMatterAtom statesOfMatterAtom) {
        this.m_movableParticle = statesOfMatterAtom;
        this.m_movableParticleNode = new GrabbableParticleNode(this.m_model, statesOfMatterAtom, this.m_mvt, true, true, 0.0, Double.POSITIVE_INFINITY);
        this.m_movableParticleNode.setShowAttractiveForces(this.m_showAttractiveForces);
        this.m_movableParticleNode.setShowRepulsiveForces(this.m_showRepulsiveForces);
        this.m_movableParticleNode.setShowTotalForces(this.m_showTotalForces);
        this.m_movableParticleLayer.addChild(this.m_movableParticleNode);
        this.updateMinimumXForMovableAtom();
        statesOfMatterAtom.addListener(this.m_atomListener);
        this.updatePositionMarkerOnDiagram();
    }

    private void handleMovableParticleRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        if (this.m_movableParticleNode != null) {
            this.m_movableParticleLayer.removeChild(this.m_movableParticleNode);
        } else {
            System.err.println("Error: Problem encountered removing node from canvas.");
        }
        statesOfMatterAtom.removeListener(this.m_atomListener);
        this.updatePositionMarkerOnDiagram();
        this.m_movableParticleNode = null;
    }

    private void handleParticleRadiusChanged() {
        if (this.m_model.getMotionPaused()) {
            if (this.m_fixedParticleNode.getGradientEnabled()) {
                this.m_fixedParticleNode.setGradientEnabled(false);
            }
            if (this.m_movableParticleNode.getGradientEnabled()) {
                this.m_movableParticleNode.setGradientEnabled(false);
            }
        }
    }

    private void handlePositionChanged() {
        if (!this.m_model.getMotionPaused()) {
            if (!this.m_fixedParticleNode.getGradientEnabled()) {
                this.m_fixedParticleNode.setGradientEnabled(true);
            }
            if (!this.m_movableParticleNode.getGradientEnabled()) {
                this.m_movableParticleNode.setGradientEnabled(true);
            }
        }
        this.updatePositionMarkerOnDiagram();
        this.updateForceVectors();
        if (this.getWorldSize().getWidth() > 0.0 && this.m_model.getMovableAtomRef().getX() > 0.7 * this.getWorldSize().getWidth()) {
            if (!this.m_retrieveAtomButtonNode.isVisible()) {
                this.m_retrieveAtomButtonNode.setVisible(true);
            }
        } else if (this.m_retrieveAtomButtonNode.isVisible()) {
            this.m_retrieveAtomButtonNode.setVisible(false);
        }
    }

    private void updatePositionMarkerOnDiagram() {
        if (this.m_fixedParticle != null && this.m_movableParticle != null) {
            double d = this.m_fixedParticle.getPositionReference().distance(this.m_movableParticle.getPositionReference());
            if (d > 0.0) {
                this.m_interactionPotentialDiagram.setMarkerEnabled(true);
                this.m_interactionPotentialDiagram.setMarkerPosition(d);
            } else {
                this.m_interactionPotentialDiagram.setMarkerEnabled(false);
            }
        } else {
            this.m_interactionPotentialDiagram.setMarkerEnabled(false);
        }
    }

    private void updateMinimumXForMovableAtom() {
        if (this.m_movableParticle != null && this.m_fixedParticle != null) {
            this.m_movableParticleNode.setMinX(this.m_model.getSigma() * 0.9);
        }
    }

    private void updateForceVectors() {
        if (this.m_fixedParticle != null && this.m_movableParticle != null) {
            this.m_fixedParticleNode.setForces(this.m_model.getAttractiveForce(), -this.m_model.getRepulsiveForce());
            this.m_movableParticleNode.setForces(-this.m_model.getAttractiveForce(), this.m_model.getRepulsiveForce());
        }
    }

    private void clearWiggleMe() {
        if (this.m_wiggleMe != null) {
            this.m_wiggleMe.setEnabled(false);
            this.removeWorldChild(this.m_wiggleMe);
            this.m_wiggleMe = null;
        }
    }
}

