/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.phasechanges;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ResizeArrowNode;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.module.InteractionPotentialDiagramNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class EpsilonControlInteractionPotentialDiagram
extends InteractionPotentialDiagramNode {
    private static final Color RESIZE_HANDLE_NORMAL_COLOR = Color.GREEN;
    private static final Color RESIZE_HANDLE_HIGHLIGHTED_COLOR = Color.YELLOW;
    private static final Stroke EPSILON_LINE_STROKE = new BasicStroke(1.0f);
    private static final Color EPSILON_LINE_COLOR = RESIZE_HANDLE_NORMAL_COLOR;
    private final MultipleParticleModel m_model;
    private final ResizeArrowNode m_epsilonResizeHandle;
    private final PPath m_epsilonLine;
    private boolean m_interactionEnabled;

    public EpsilonControlInteractionPotentialDiagram(double d, double d2, boolean bl, MultipleParticleModel multipleParticleModel) {
        super(d, d2, bl, true);
        this.m_model = multipleParticleModel;
        multipleParticleModel.addListener(new MultipleParticleModel.Adapter(){

            public void interactionStrengthChanged() {
                EpsilonControlInteractionPotentialDiagram.this.setLjPotentialParameters(EpsilonControlInteractionPotentialDiagram.this.m_model.getSigma(), EpsilonControlInteractionPotentialDiagram.this.m_model.getEpsilon());
            }

            public void moleculeTypeChanged() {
                EpsilonControlInteractionPotentialDiagram.this.updateInteractivityState();
                EpsilonControlInteractionPotentialDiagram.this.drawPotentialCurve();
            }
        });
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                PNode pNode = pInputEvent.getPickedNode();
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
                pNode.localToParent(pDimension);
                double d = 450.0 / (EpsilonControlInteractionPotentialDiagram.this.getGraphHeight() / 2.0);
                EpsilonControlInteractionPotentialDiagram.this.m_model.setEpsilon(EpsilonControlInteractionPotentialDiagram.this.m_model.getEpsilon() + pDimension.getHeight() * d);
            }
        };
        double d3 = 0.08 * this.m_width * 2.2;
        this.m_epsilonLine = new PPath(new Line2D.Double(-d3 / 3.0, 0.0, d3 / 2.0, 0.0));
        this.m_epsilonLine.setStroke(EPSILON_LINE_STROKE);
        this.m_epsilonLine.setStrokePaint(EPSILON_LINE_COLOR);
        this.m_epsilonLine.addInputEventListener(new CursorHandler(8));
        this.m_epsilonLine.addInputEventListener(pBasicInputEventHandler);
        this.m_ljPotentialGraph.addChild(this.m_epsilonLine);
        this.m_epsilonResizeHandle = new ResizeArrowNode(0.12 * this.m_width, 1.5707963267948966, RESIZE_HANDLE_NORMAL_COLOR, RESIZE_HANDLE_HIGHLIGHTED_COLOR);
        this.m_ljPotentialGraph.addChild(this.m_epsilonResizeHandle);
        this.m_epsilonResizeHandle.addInputEventListener(pBasicInputEventHandler);
        this.updateInteractivityState();
    }

    protected void drawPotentialCurve() {
        super.drawPotentialCurve();
        if (this.m_epsilonResizeHandle != null) {
            Point2D point2D = this.getGraphMin();
            this.m_epsilonResizeHandle.setOffset(point2D.getX() + this.m_width * 0.08, point2D.getY());
            this.m_epsilonResizeHandle.setVisible(this.m_interactionEnabled);
            this.m_epsilonResizeHandle.setPickable(this.m_interactionEnabled);
            this.m_epsilonResizeHandle.setChildrenPickable(this.m_interactionEnabled);
            this.m_epsilonLine.setOffset(point2D.getX(), point2D.getY() + 1.0);
            this.m_epsilonLine.setVisible(this.m_interactionEnabled);
            this.m_epsilonLine.setPickable(this.m_interactionEnabled);
        }
    }

    private void updateInteractivityState() {
        this.m_interactionEnabled = this.m_model.getMoleculeType() == 6;
    }
}

