/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.phasechanges;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterGlobalState;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.view.BicyclePumpNode;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleContainerNode;
import edu.colorado.phet.statesofmatter.view.StoveNode;
import edu.colorado.phet.statesofmatter.view.instruments.CompositeThermometerNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class PhaseChangesCanvas
extends PhetPCanvas
implements Resettable {
    private final MultipleParticleModel m_model;
    private final ParticleContainerNode m_particleContainer;
    private final CompositeThermometerNode m_thermometerNode;
    private final Random m_rand;
    private double m_rotationRate = 0.0;
    private final BooleanProperty m_clockRunning = new BooleanProperty(false);

    public PhaseChangesCanvas(final MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        this.m_rand = new Random();
        ModelViewTransform modelViewTransform = new ModelViewTransform(1.0, 1.0, 0.0, 0.0, false, true);
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(24000.0, 18000.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)PhaseChangesCanvas.this.getWidth() * 0.29, (double)PhaseChangesCanvas.this.getHeight() * 0.73);
            }
        });
        StatesOfMatterGlobalState.whiteBackground.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    PhaseChangesCanvas.this.setBackground(Color.WHITE);
                } else {
                    PhaseChangesCanvas.this.setBackground(StatesOfMatterConstants.CANVAS_BACKGROUND);
                }
            }
        });
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void temperatureChanged() {
                PhaseChangesCanvas.this.updateThermometerTemperature();
            }

            public void containerSizeChanged() {
                PhaseChangesCanvas.this.updateThermometerPosition();
            }

            public void containerExplodedStateChanged(boolean bl) {
                if (bl) {
                    PhaseChangesCanvas.this.m_rotationRate = -(0.031415926535897934 + PhaseChangesCanvas.this.m_rand.nextDouble() * Math.PI / 50.0);
                } else {
                    PhaseChangesCanvas.this.m_rotationRate = 0.0;
                }
            }
        });
        this.m_particleContainer = new ParticleContainerNode(this.m_model, modelViewTransform, true, true);
        Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
        BicyclePumpNode bicyclePumpNode = new BicyclePumpNode(6000.0, 9000.0, this.m_model);
        bicyclePumpNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() - bicyclePumpNode.getFullBoundsReference().height - rectangle2D.getHeight() * 0.2);
        this.addWorldChild(bicyclePumpNode);
        this.addWorldChild(this.m_particleContainer);
        this.m_thermometerNode = new CompositeThermometerNode(rectangle2D.getWidth() * 0.2, rectangle2D.getHeight() * 0.32, 1000.0, StatesOfMatterGlobalState.temperatureUnitsProperty);
        this.addWorldChild(this.m_thermometerNode);
        this.updateThermometerTemperature();
        this.updateThermometerPosition();
        StoveNode stoveNode = new StoveNode(this.m_model);
        stoveNode.setScale(3600.0 / stoveNode.getFullBoundsReference().height);
        stoveNode.setOffset(rectangle2D.getCenterX() - stoveNode.getFullBoundsReference().width / 2.0, this.m_particleContainer.getFullBoundsReference().getMaxY() + 600.0);
        this.addWorldChild(stoveNode);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{multipleParticleModel, this}, this, 18, Color.BLACK, new Color(255, 153, 0)){
            {
                this.setConfirmationEnabled(false);
                this.scale(30.0);
            }
        };
        this.addWorldChild(resetAllButtonNode);
        this.m_clockRunning.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                multipleParticleModel.getClock().setRunning(bl);
            }
        });
        FloatingClockControlNode floatingClockControlNode = new FloatingClockControlNode(this.m_clockRunning, null, multipleParticleModel.getClock(), null, new Property<Color>(Color.white)){
            {
                this.scale(30.0);
            }
        };
        this.addWorldChild(floatingClockControlNode);
        double d = -Math.max(resetAllButtonNode.getFullBoundsReference().width, floatingClockControlNode.getFullBoundsReference().width) / 2.0;
        resetAllButtonNode.setOffset(d - resetAllButtonNode.getFullBoundsReference().width / 2.0, stoveNode.getFullBoundsReference().getMaxY() - resetAllButtonNode.getFullBoundsReference().height);
        floatingClockControlNode.setOffset(resetAllButtonNode.getFullBoundsReference().getCenterX() - floatingClockControlNode.getFullBoundsReference().width / 2.0, resetAllButtonNode.getFullBoundsReference().getMinY() - floatingClockControlNode.getFullBoundsReference().height - 200.0);
        final TextButtonNode textButtonNode = new TextButtonNode(StatesOfMatterStrings.RETURN_LID, new PhetFont(18), Color.YELLOW){
            {
                super(string, font, color);
                this.scale(30.0);
                this.setOffset(-this.getFullBoundsReference().getWidth() - 500.0, -8000.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        multipleParticleModel.returnLid();
                    }
                });
            }
        };
        this.addWorldChild(textButtonNode);
        textButtonNode.setVisible(multipleParticleModel.getContainerExploded());
        multipleParticleModel.addListener(new MultipleParticleModel.Adapter(){

            public void containerExplodedStateChanged(boolean bl) {
                textButtonNode.setVisible(bl);
            }
        });
        multipleParticleModel.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                PhaseChangesCanvas.this.m_clockRunning.set(true);
            }
        });
    }

    public void reset() {
        this.m_clockRunning.set(true);
        this.m_particleContainer.reset();
    }

    private void updateThermometerTemperature() {
        this.m_thermometerNode.setTemperatureInDegreesKelvin(this.m_model.getTemperatureInKelvin());
    }

    private void updateThermometerPosition() {
        Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
        if (!this.m_model.getContainerExploded()) {
            if (this.m_thermometerNode.getRotation() != 0.0) {
                this.m_thermometerNode.setRotation(0.0);
            }
        } else {
            this.m_thermometerNode.rotateInPlace(this.m_rotationRate);
        }
        this.m_thermometerNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth() * 0.24, rectangle2D.getY() - rectangle2D.getHeight() - this.m_thermometerNode.getFullBoundsReference().height * 0.5);
    }
}

