/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.phasechanges;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.module.CloseRequestListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class PhaseDiagram
extends PhetPCanvas {
    private static final Font AXIS_LABEL_FONT = new PhetFont(14);
    private static final Font LARGER_INNER_FONT = new PhetFont(14);
    private static final Font SMALLER_INNER_FONT = new PhetFont(12);
    private static final Color BACKGROUND_COLOR_FOR_SOLID = new Color(13024726);
    private static final Color BACKGROUND_COLOR_FOR_LIQUID = new Color(0x88FFBB);
    private static final Color BACKGROUND_COLOR_FOR_GAS = new Color(0xFFBB00);
    private static final Color CURRENT_STATE_MARKER_COLOR = Color.RED;
    private static final Point2D DEFAULT_TOP_OF_SOLID_LIQUID_LINE = new Point2D.Double(87.2, 17.599999999999994);
    private static final Point2D TOP_OF_SOLID_LIQUID_LINE_FOR_WATER = new Point2D.Double(70.4, 17.599999999999994);
    private static final Point2D DEFAULT_TRIPLE_POINT = new Point2D.Double(78.8, 112.32);
    private static final Point2D DEFAULT_CRITICAL_POINT = new Point2D.Double(154.4, 82.72);
    private static final Point2D DEFAULT_SOLID_LABEL_LOCATION = new Point2D.Double(53.6, 50.751999999999995);
    private static final Point2D DEFAULT_LIQUID_LABEL_LOCATION = new Point2D.Double(120.8, 64.96);
    private static final Point2D DEFAULT_GAS_LABEL_LOCATION = new Point2D.Double(120.8, 118.24);
    private final PPath m_triplePoint;
    private final PPath m_criticalPoint;
    private final PPath m_solidLiquidLine;
    private final PPath m_solidGasLine;
    private final PPath m_solidAreaBackground;
    private final PPath m_liquidGasLine;
    private final PPath m_liquidAreaBackground;
    private final PText m_solidLabel;
    private final PText m_liquidLabel;
    private final PText m_gasLabel;
    private final PPath m_gasAreaBackground;
    private final PPath m_superCriticalAreaBackground;
    private final HTMLNode m_triplePointLabel;
    private final HTMLNode m_criticalPointLabel;
    private final PPath m_currentStateMarker;
    private final Point2D m_topOfSolidLiquidLine;
    final Point2D m_currentStateMarkerPos;
    final JButton m_closeButton;
    final PSwing m_closePSwing;
    private final ArrayList _listeners = new ArrayList();

    public PhaseDiagram() {
        this.m_currentStateMarkerPos = new Point2D.Double();
        this.setPreferredSize(new Dimension(200, 160));
        this.setBackground(StatesOfMatterConstants.CONTROL_PANEL_COLOR);
        this.setBorder(null);
        this.m_topOfSolidLiquidLine = new Point2D.Double(DEFAULT_TOP_OF_SOLID_LIQUID_LINE.getX(), DEFAULT_TOP_OF_SOLID_LIQUID_LINE.getY());
        this.m_gasAreaBackground = new PPath();
        this.m_gasAreaBackground.setPaint(BACKGROUND_COLOR_FOR_GAS);
        this.m_gasAreaBackground.setStrokePaint(BACKGROUND_COLOR_FOR_GAS);
        this.addWorldChild(this.m_gasAreaBackground);
        this.m_superCriticalAreaBackground = new PPath();
        this.m_superCriticalAreaBackground.setPaint(this.getSuperCriticalRegionPaint());
        this.m_superCriticalAreaBackground.setStrokePaint(this.getSuperCriticalRegionPaint());
        this.addWorldChild(this.m_superCriticalAreaBackground);
        this.m_liquidAreaBackground = new PPath();
        this.m_liquidAreaBackground.setPaint(BACKGROUND_COLOR_FOR_LIQUID);
        this.m_liquidAreaBackground.setStrokePaint(BACKGROUND_COLOR_FOR_LIQUID);
        this.addWorldChild(this.m_liquidAreaBackground);
        this.m_solidAreaBackground = new PPath();
        this.m_solidAreaBackground.setPaint(BACKGROUND_COLOR_FOR_SOLID);
        this.m_solidAreaBackground.setStrokePaint(BACKGROUND_COLOR_FOR_SOLID);
        this.addWorldChild(this.m_solidAreaBackground);
        this.m_solidLiquidLine = new PPath();
        this.addWorldChild(this.m_solidLiquidLine);
        this.m_solidGasLine = new PPath();
        this.addWorldChild(this.m_solidGasLine);
        this.m_liquidGasLine = new PPath();
        this.addWorldChild(this.m_liquidGasLine);
        this.m_triplePoint = new PPath(new Ellipse2D.Double(0.0, 0.0, 4.0, 4.0));
        this.m_triplePoint.setPaint(Color.BLACK);
        this.addWorldChild(this.m_triplePoint);
        this.m_criticalPoint = new PPath(new Ellipse2D.Double(0.0, 0.0, 4.0, 4.0));
        this.m_criticalPoint.setPaint(Color.BLACK);
        this.addWorldChild(this.m_criticalPoint);
        this.m_solidLabel = new PText(StatesOfMatterStrings.PHASE_DIAGRAM_SOLID);
        this.m_solidLabel.setFont(LARGER_INNER_FONT);
        this.addWorldChild(this.m_solidLabel);
        this.m_liquidLabel = new PText(StatesOfMatterStrings.PHASE_DIAGRAM_LIQUID);
        this.m_liquidLabel.setFont(LARGER_INNER_FONT);
        this.addWorldChild(this.m_liquidLabel);
        this.m_gasLabel = new PText(StatesOfMatterStrings.PHASE_DIAGRAM_GAS);
        this.m_gasLabel.setFont(LARGER_INNER_FONT);
        this.addWorldChild(this.m_gasLabel);
        this.m_triplePointLabel = new HTMLNode(StatesOfMatterStrings.PHASE_DIAGRAM_TRIPLE_POINT);
        this.m_triplePointLabel.setFont(SMALLER_INNER_FONT);
        this.addWorldChild(this.m_triplePointLabel);
        this.m_criticalPointLabel = new HTMLNode(StatesOfMatterStrings.PHASE_DIAGRAM_CRITICAL_POINT);
        this.m_criticalPointLabel.setFont(SMALLER_INNER_FONT);
        this.addWorldChild(this.m_criticalPointLabel);
        ArrowNode arrowNode = new ArrowNode(new Point2D.Double(20.0, 136.0), new Point2D.Double(196.0, 136.0), 8.0, 5.0, 1.0);
        arrowNode.setPaint(Color.BLACK);
        this.addWorldChild(arrowNode);
        ArrowNode arrowNode2 = new ArrowNode(new Point2D.Double(20.0, 136.0), new Point2D.Double(20.0, 9.599999999999994), 8.0, 5.0, 1.0);
        arrowNode2.setPaint(Color.BLACK);
        this.addWorldChild(arrowNode2);
        PText pText = new PText(StatesOfMatterStrings.PHASE_DIAGRAM_X_AXIS_LABEL);
        pText.setFont(AXIS_LABEL_FONT);
        pText.setOffset(100.0 - pText.getFullBoundsReference().width / 2.0, 136.0 + pText.getFullBoundsReference().height * 0.3);
        this.addWorldChild(pText);
        PText pText2 = new PText(StatesOfMatterStrings.PHASE_DIAGRAM_Y_AXIS_LABEL);
        pText2.setFont(AXIS_LABEL_FONT);
        pText2.setOffset(20.0 - pText2.getFullBoundsReference().height * 1.1, pText2.getFullBoundsReference().width * 1.6);
        pText2.rotate(4.71238898038469);
        this.addWorldChild(pText2);
        this.m_currentStateMarker = new PPath(new Ellipse2D.Double(0.0, 0.0, 7.0, 7.0));
        this.m_currentStateMarker.setPaint(CURRENT_STATE_MARKER_COLOR);
        this.m_currentStateMarker.setStrokePaint(CURRENT_STATE_MARKER_COLOR);
        this.addWorldChild(this.m_currentStateMarker);
        this.m_closeButton = new JButton(new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png")));
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhaseDiagram.this.notifyCloseRequestReceived();
            }
        });
        this.m_closePSwing = new PSwing(this.m_closeButton);
        this.addWorldChild(this.m_closePSwing);
        this.drawPhaseDiagram();
        this.setStateMarkerPos(0.0, 0.0);
    }

    public void addListener(CloseRequestListener closeRequestListener) {
        if (!this._listeners.contains(closeRequestListener)) {
            this._listeners.add(closeRequestListener);
        }
    }

    private void drawPhaseDiagram() {
        this.m_triplePoint.setOffset(DEFAULT_TRIPLE_POINT.getX() - 2.0, DEFAULT_TRIPLE_POINT.getY() - 2.0);
        QuadCurve2D.Double double_ = new QuadCurve2D.Double(20.0, 136.0, 53.6, 133.632, DEFAULT_TRIPLE_POINT.getX(), DEFAULT_TRIPLE_POINT.getY());
        this.m_solidGasLine.setPathTo(double_);
        Line2D.Double double_2 = new Line2D.Double(DEFAULT_TRIPLE_POINT.getX(), DEFAULT_TRIPLE_POINT.getY(), this.m_topOfSolidLiquidLine.getX(), this.m_topOfSolidLiquidLine.getY());
        this.m_solidLiquidLine.setPathTo(double_2);
        GeneralPath generalPath = new GeneralPath(double_);
        generalPath.lineTo((float)this.m_topOfSolidLiquidLine.getX(), (float)this.m_topOfSolidLiquidLine.getY());
        generalPath.lineTo(20.0f, 17.6f);
        generalPath.lineTo(20.0f, 136.0f);
        generalPath.closePath();
        this.m_solidAreaBackground.setPathTo(generalPath);
        this.m_criticalPoint.setOffset(DEFAULT_CRITICAL_POINT.getX() - 2.0, DEFAULT_CRITICAL_POINT.getY() - 2.0);
        double d = DEFAULT_TRIPLE_POINT.getX() + (DEFAULT_CRITICAL_POINT.getX() - DEFAULT_TRIPLE_POINT.getX()) / 2.0;
        double d2 = DEFAULT_TRIPLE_POINT.getY();
        QuadCurve2D.Double double_3 = new QuadCurve2D.Double(DEFAULT_TRIPLE_POINT.getX(), DEFAULT_TRIPLE_POINT.getY(), d, d2, DEFAULT_CRITICAL_POINT.getX(), DEFAULT_CRITICAL_POINT.getY());
        this.m_liquidGasLine.setPathTo(double_3);
        GeneralPath generalPath2 = new GeneralPath(double_3);
        generalPath2.lineTo(188.0f, 17.6f);
        generalPath2.lineTo((float)this.m_topOfSolidLiquidLine.getX(), 17.6f);
        generalPath2.lineTo((float)DEFAULT_TRIPLE_POINT.getX(), (float)DEFAULT_TRIPLE_POINT.getY());
        generalPath2.append(double_3, true);
        generalPath2.closePath();
        this.m_liquidAreaBackground.setPathTo(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(20.0f, 136.0f);
        generalPath3.lineTo((float)DEFAULT_TRIPLE_POINT.getX(), (float)DEFAULT_TRIPLE_POINT.getY());
        generalPath3.lineTo((float)DEFAULT_CRITICAL_POINT.getX(), (float)DEFAULT_CRITICAL_POINT.getY());
        generalPath3.lineTo(188.0f, 136.0f);
        generalPath3.lineTo(20.0f, 136.0f);
        generalPath3.closePath();
        this.m_gasAreaBackground.setPathTo(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo((float)DEFAULT_CRITICAL_POINT.getX(), (float)DEFAULT_CRITICAL_POINT.getY());
        generalPath4.lineTo(188.0f, 136.0f);
        generalPath4.lineTo(188.0f, 17.6f);
        generalPath4.lineTo((float)DEFAULT_CRITICAL_POINT.getX(), (float)DEFAULT_CRITICAL_POINT.getY());
        generalPath4.closePath();
        this.m_superCriticalAreaBackground.setPathTo(generalPath4);
        this.m_solidLabel.setOffset(DEFAULT_SOLID_LABEL_LOCATION.getX() - this.m_solidLabel.getFullBoundsReference().width / 2.0, DEFAULT_SOLID_LABEL_LOCATION.getY() - this.m_solidLabel.getFullBoundsReference().height / 2.0);
        this.m_liquidLabel.setOffset(DEFAULT_LIQUID_LABEL_LOCATION.getX() - this.m_liquidLabel.getFullBoundsReference().width / 2.0, DEFAULT_LIQUID_LABEL_LOCATION.getY() - this.m_liquidLabel.getFullBoundsReference().height / 2.0);
        this.m_gasLabel.setOffset(DEFAULT_GAS_LABEL_LOCATION.getX() - this.m_gasLabel.getFullBoundsReference().width / 2.0, DEFAULT_GAS_LABEL_LOCATION.getY() - this.m_gasLabel.getFullBoundsReference().height / 2.0);
        this.m_triplePointLabel.setOffset(DEFAULT_TRIPLE_POINT.getX() - this.m_triplePointLabel.getFullBoundsReference().width * 1.2, DEFAULT_TRIPLE_POINT.getY() - this.m_triplePointLabel.getFullBoundsReference().height * 0.9);
        this.m_criticalPointLabel.setOffset(DEFAULT_CRITICAL_POINT.getX() + 4.0, DEFAULT_CRITICAL_POINT.getY() - this.m_criticalPointLabel.getFullBoundsReference().height / 2.0);
        this.m_closePSwing.setScale(1.0);
        this.m_closePSwing.setScale(17.6 / this.m_closePSwing.getFullBoundsReference().height);
        this.m_closePSwing.setOffset(200.0 - this.m_closePSwing.getFullBoundsReference().width, 0.0);
    }

    public void setStateMarkerPos(double d, double d2) {
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Value out of range, temperature = " + d + ", pressure = " + d2);
        }
        this.m_currentStateMarkerPos.setLocation(d, d2);
        double d3 = d * 168.0 + 20.0 - 3.5;
        double d4 = -d2 * 118.4 + 136.0 - 3.5;
        if (d3 + 7.0 > 188.0) {
            d3 = 181.0;
        }
        if (d4 < 17.599999999999994) {
            d4 = 17.599999999999994;
        }
        this.m_currentStateMarker.setOffset(d3, d4);
    }

    public void setStateMarkerVisible(boolean bl) {
        this.m_currentStateMarker.setVisible(bl);
    }

    public void setDepictingWater(boolean bl) {
        if (bl) {
            this.m_topOfSolidLiquidLine.setLocation(TOP_OF_SOLID_LIQUID_LINE_FOR_WATER);
        } else {
            this.m_topOfSolidLiquidLine.setLocation(DEFAULT_TOP_OF_SOLID_LIQUID_LINE);
        }
        this.drawPhaseDiagram();
    }

    private Paint getSuperCriticalRegionPaint() {
        if (PhetUtilities.getOperatingSystem() == 1) {
            int n = (BACKGROUND_COLOR_FOR_GAS.getRed() + BACKGROUND_COLOR_FOR_LIQUID.getRed()) / 2;
            int n2 = (BACKGROUND_COLOR_FOR_GAS.getGreen() + BACKGROUND_COLOR_FOR_LIQUID.getGreen()) / 2;
            int n3 = (BACKGROUND_COLOR_FOR_GAS.getBlue() + BACKGROUND_COLOR_FOR_LIQUID.getBlue()) / 2;
            return new Color(n, n2, n3);
        }
        Point2D.Double double_ = new Point2D.Double(154.4, 29.439999999999998);
        Point2D.Double double_2 = new Point2D.Double(154.4, 124.16);
        return new GradientPaint(double_2, BACKGROUND_COLOR_FOR_GAS, double_, BACKGROUND_COLOR_FOR_LIQUID);
    }

    private void notifyCloseRequestReceived() {
        for (Object e : this._listeners) {
            ((CloseRequestListener)e).closeRequestReceived();
        }
    }
}

