/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.solidliquidgas;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.module.solidliquidgas.MoleculeImageLabel;
import edu.colorado.phet.statesofmatter.module.solidliquidgas.SolidLiquidGasModule;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class SolidLiquidGasControlPanel
extends ControlPanel {
    private static final Font BUTTON_FONT = new PhetFont(0, 16);
    final MultipleParticleModel m_model;
    final ChangeStateControlPanel m_stateSelectionPanel;
    MoleculeSelectionPanel m_moleculeSelectionPanel;

    public SolidLiquidGasControlPanel(SolidLiquidGasModule solidLiquidGasModule) {
        this.m_model = solidLiquidGasModule.getMultiParticleModel();
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void moleculeTypeChanged() {
                SolidLiquidGasControlPanel.this.m_moleculeSelectionPanel.setMolecule(SolidLiquidGasControlPanel.this.m_model.getMoleculeType());
            }
        });
        int n = StatesOfMatterResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this.m_moleculeSelectionPanel = new MoleculeSelectionPanel(this.m_model);
        this.addControlFullWidth(this.m_moleculeSelectionPanel);
        this.m_stateSelectionPanel = new ChangeStateControlPanel();
        this.addControlFullWidth(this.m_stateSelectionPanel);
    }

    private class ChangeStateControlPanel
    extends VerticalLayoutPanel {
        private final JButton m_solidButton;
        private final JButton m_liquidButton;
        private final JButton m_gasButton;

        ChangeStateControlPanel() {
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.FORCE_STATE_CHANGE, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            BufferedImage bufferedImage = StatesOfMatterResources.getImage("ice-cube.png");
            double d = 32.0 / (double)bufferedImage.getHeight();
            bufferedImage = BufferedImageUtils.rescaleFractional(bufferedImage, d, d);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            bufferedImage = StatesOfMatterResources.getImage("liquid-in-cup.png");
            d = 32.0 / (double)bufferedImage.getHeight();
            bufferedImage = BufferedImageUtils.rescaleFractional(bufferedImage, d, d);
            ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
            bufferedImage = StatesOfMatterResources.getImage("gas.png");
            d = 32.0 / (double)bufferedImage.getHeight();
            bufferedImage = BufferedImageUtils.rescaleFractional(bufferedImage, d, d);
            ImageIcon imageIcon3 = new ImageIcon(bufferedImage);
            this.m_solidButton = new JButton(StatesOfMatterStrings.PHASE_STATE_SOLID, imageIcon);
            this.m_solidButton.setFont(BUTTON_FONT);
            this.m_solidButton.setAlignmentX(0.5f);
            this.m_solidButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SolidLiquidGasControlPanel.this.m_model.setPhase(1);
                }
            });
            this.m_liquidButton = new JButton(StatesOfMatterStrings.PHASE_STATE_LIQUID, imageIcon2);
            this.m_liquidButton.setFont(BUTTON_FONT);
            this.m_liquidButton.setAlignmentX(0.5f);
            this.m_liquidButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SolidLiquidGasControlPanel.this.m_model.setPhase(2);
                }
            });
            this.m_gasButton = new JButton(StatesOfMatterStrings.PHASE_STATE_GAS, imageIcon3);
            this.m_gasButton.setFont(BUTTON_FONT);
            this.m_gasButton.setAlignmentX(0.5f);
            this.m_gasButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SolidLiquidGasControlPanel.this.m_model.setPhase(3);
                }
            });
            this.add(this.m_solidButton);
            this.add(this.m_liquidButton);
            this.add(this.m_gasButton);
        }
    }

    private static class MoleculeSelectionPanel
    extends JPanel {
        private final JRadioButton m_neonRadioButton;
        private final JRadioButton m_argonRadioButton;
        private final JRadioButton m_oxygenRadioButton;
        private final JRadioButton m_waterRadioButton;

        MoleculeSelectionPanel(MultipleParticleModel multipleParticleModel) {
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.MOLECULE_TYPE_SELECT_LABEL, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_oxygenRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL, multipleParticleModel, 4);
            final MoleculeImageLabel moleculeImageLabel = new MoleculeImageLabel(4, multipleParticleModel);
            this.m_neonRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.NEON_SELECTION_LABEL, multipleParticleModel, 1);
            final MoleculeImageLabel moleculeImageLabel2 = new MoleculeImageLabel(1, multipleParticleModel);
            this.m_argonRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.ARGON_SELECTION_LABEL, multipleParticleModel, 2);
            final MoleculeImageLabel moleculeImageLabel3 = new MoleculeImageLabel(2, multipleParticleModel);
            this.m_waterRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.WATER_SELECTION_LABEL, multipleParticleModel, 5);
            final MoleculeImageLabel moleculeImageLabel4 = new MoleculeImageLabel(5, multipleParticleModel);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_neonRadioButton);
            buttonGroup.add(this.m_argonRadioButton);
            buttonGroup.add(this.m_oxygenRadioButton);
            buttonGroup.add(this.m_waterRadioButton);
            this.m_neonRadioButton.setSelected(true);
            this.setLayout(new GridLayout(4, 1));
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_neonRadioButton);
                    this.add(moleculeImageLabel2);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_argonRadioButton);
                    this.add(moleculeImageLabel3);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_oxygenRadioButton);
                    this.add(moleculeImageLabel);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_waterRadioButton);
                    this.add(moleculeImageLabel4);
                }
            });
        }

        public void setMolecule(int n) {
            switch (n) {
                case 2: {
                    this.m_argonRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.m_neonRadioButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.m_oxygenRadioButton.setSelected(true);
                    break;
                }
                case 5: {
                    this.m_waterRadioButton.setSelected(true);
                }
            }
        }
    }

    private static class MoleculeSelectorButton
    extends JRadioButton {
        private static final Font LABEL_FONT = new PhetFont(0, 14);

        private MoleculeSelectorButton(String string, final MultipleParticleModel multipleParticleModel, final int n) {
            super(string);
            this.setFont(LABEL_FONT);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (multipleParticleModel.getMoleculeType() != n) {
                        multipleParticleModel.setMoleculeType(n);
                    }
                }
            });
        }
    }
}

