/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Rectangle2D;

public class BicyclePumpNode
extends PNode {
    private static final Color PUMP_BASE_COLOR = new Color(0xBB8855);
    private static final Color PUMP_BODY_COLOR = Color.red;
    private static final Color PUMP_SHAFT_COLOR = Color.LIGHT_GRAY;
    private static final Color PUMP_HANDLE_COLOR = new Color(0xDDAA77);
    private static final Color HOSE_CONNECTOR_COLOR = new Color(0xFFFF99);
    private static final Color HOSE_COLOR = new Color(200, 200, 200);
    final MultipleParticleModel m_model;
    final PPath m_pumpHandle;
    double m_currentHandleOffset;
    final double m_maxHandleOffset;
    final double m_pumpingRequiredToInject;
    double m_currentPumpingAmount;
    PPath m_pumpShaft;

    public BicyclePumpNode(double d, double d2, MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        this.m_pumpingRequiredToInject = d2 * 0.075;
        this.m_currentPumpingAmount = 0.0;
        double d3 = d * 0.4;
        double d4 = d2 * 0.02;
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, d3, d4));
        pPath.setPaint(PUMP_BASE_COLOR);
        pPath.setOffset(d * 0.85 - d3 / 2.0, d2 - d4);
        pPath.setPickable(false);
        this.addChild(pPath);
        double d5 = d * 0.35;
        double d6 = d2 * 0.02;
        this.m_pumpHandle = new PPath(new Rectangle2D.Double(0.0, 0.0, d5, d6));
        this.m_pumpHandle.setPaint(PUMP_HANDLE_COLOR);
        this.m_pumpHandle.setOffset(d * 0.85 - d5 / 2.0, d2 - d2 * 0.8250000000000001 - d6);
        this.m_pumpHandle.setPickable(true);
        this.m_pumpHandle.addInputEventListener(new CursorHandler(8));
        this.m_currentHandleOffset = 0.0;
        this.m_maxHandleOffset = -0.75 * d2 / 2.0;
        this.addChild(this.m_pumpHandle);
        this.m_pumpHandle.addInputEventListener(new PDragEventHandler(){

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
            }

            public void drag(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(BicyclePumpNode.this.m_pumpHandle);
                BicyclePumpNode.this.m_pumpHandle.localToParent(pDimension);
                if (BicyclePumpNode.this.m_currentHandleOffset + pDimension.getHeight() >= BicyclePumpNode.this.m_maxHandleOffset && BicyclePumpNode.this.m_currentHandleOffset + pDimension.getHeight() <= 0.0) {
                    BicyclePumpNode.this.m_pumpHandle.offset(0.0, pDimension.getHeight());
                    BicyclePumpNode.this.m_pumpShaft.offset(0.0, pDimension.getHeight());
                    BicyclePumpNode.this.m_currentHandleOffset += pDimension.getHeight();
                    if (pDimension.getHeight() > 0.0) {
                        BicyclePumpNode.this.m_currentPumpingAmount += pDimension.getHeight();
                        if (BicyclePumpNode.this.m_currentPumpingAmount >= BicyclePumpNode.this.m_pumpingRequiredToInject) {
                            BicyclePumpNode.this.m_model.injectMolecule();
                            BicyclePumpNode.this.m_currentPumpingAmount = 0.0;
                        }
                    }
                }
            }
        });
        double d7 = d * 0.025;
        double d8 = d2 * 0.75;
        this.m_pumpShaft = new PPath(new Rectangle2D.Double(0.0, 0.0, d7, d8));
        this.m_pumpShaft.setPaint(PUMP_SHAFT_COLOR);
        this.m_pumpShaft.setOffset(d * 0.85 - d7 / 2.0, d2 - d2 * 0.8250000000000001);
        this.m_pumpShaft.setPickable(false);
        this.addChild(this.m_pumpShaft);
        double d9 = 0.0;
        double d10 = d2 - d2 * 0.5 + d2 * 0.04 / 2.0;
        double d11 = d * 0.85;
        double d12 = d2 - d2 * 0.075;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d13 = 0.03 * d;
        doubleGeneralPath.moveTo(d9, d10 + d13 / 2.0);
        doubleGeneralPath.lineTo(d9, d10 - d13 / 2.0);
        doubleGeneralPath.curveTo(d + d13, d2 - d2 * 0.5 - d13 / 2.0, d13, d2 - d2 * 0.075 - d13 / 2.0, d11, d12 - d13 / 2.0);
        doubleGeneralPath.lineTo(d11, d12 + d13 / 2.0);
        doubleGeneralPath.curveTo(-d13, d2 - d2 * 0.075 + d13 / 2.0, d, d2 - d2 * 0.5 + d13 / 2.0, d9, d10 + d13 / 2.0);
        doubleGeneralPath.closePath();
        PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), HOSE_COLOR, new BasicStroke(20.0f), Color.BLACK);
        phetPPath.setPickable(false);
        this.addChild(phetPPath);
        double d14 = d * 0.05;
        double d15 = d2 * 0.04;
        PPath pPath2 = new PPath(new Rectangle2D.Double(0.0, 0.0, d14, d15));
        pPath2.setPaint(HOSE_CONNECTOR_COLOR);
        pPath2.setOffset(0.0, d2 - d2 * 0.5);
        pPath2.setPickable(false);
        this.addChild(pPath2);
        double d16 = d * 0.1;
        double d17 = d2 * 0.75;
        PhetPPath phetPPath2 = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, d16, d17));
        GradientPaint gradientPaint = new GradientPaint(0.0f, (float)d17 / 2.0f, PUMP_BODY_COLOR, (float)d16, (float)d17 / 2.0f, Color.LIGHT_GRAY);
        phetPPath2.setPaint(gradientPaint);
        phetPPath2.setOffset(d * 0.85 - d16 / 2.0, d2 - d17 - d4);
        phetPPath2.setPickable(false);
        this.addChild(phetPPath2);
    }
}

