/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.statesofmatter.model.DualAtomModel;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleForceNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;

public class GrabbableParticleNode
extends ParticleForceNode {
    final DualAtomModel m_model;
    double m_minX;
    double m_maxX;

    public GrabbableParticleNode(DualAtomModel dualAtomModel, StatesOfMatterAtom statesOfMatterAtom, ModelViewTransform modelViewTransform, boolean bl, boolean bl2, double d, double d2) {
        super(statesOfMatterAtom, modelViewTransform, bl, bl2);
        this.m_model = dualAtomModel;
        this.m_minX = d;
        this.m_maxX = d2;
        this.setPickable(true);
        this.setChildrenPickable(true);
        this.addInputEventListener(new CursorHandler(12));
        this.addInputEventListener(new PDragEventHandler(){

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                GrabbableParticleNode.this.handleMouseStartDragEvent();
            }

            public void drag(PInputEvent pInputEvent) {
                GrabbableParticleNode.this.handleMouseDragEvent(pInputEvent);
            }

            public void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                GrabbableParticleNode.this.handleMouseEndDragEvent();
            }
        });
    }

    public void setMinX(double d) {
        this.m_minX = d;
    }

    private void handleMouseStartDragEvent() {
        this.m_model.setMotionPaused(true);
    }

    private void handleMouseDragEvent(PInputEvent pInputEvent) {
        if (this.m_model.getBondingState() != 0) {
            this.m_model.releaseBond();
        }
        PNode pNode = pInputEvent.getPickedNode();
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
        pNode.localToParent(pDimension);
        double d = this.m_particle.getX() + pDimension.width;
        if (d > this.m_maxX) {
            d = this.m_maxX;
        } else if (d < this.m_minX) {
            d = this.m_minX;
        }
        this.m_particle.setPosition(d, this.m_particle.getY());
    }

    private void handleMouseEndDragEvent() {
        this.m_model.setMotionPaused(false);
    }
}

