/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HandleNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterGlobalState;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleNode;
import edu.colorado.phet.statesofmatter.view.PointingHandNode;
import edu.colorado.phet.statesofmatter.view.instruments.DialGaugeNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class ParticleContainerNode
extends PhetPNode {
    private final MultipleParticleModel m_model;
    private final ModelViewTransform m_mvt;
    private final double m_containmentAreaWidth;
    private final double m_containmentAreaHeight;
    private PNode m_lowerParticleLayer;
    private PNode m_upperParticleLayer;
    private final PNode m_topContainerLayer;
    private final PNode m_middleContainerLayer;
    private final PNode m_bottomContainerLayer;
    private PNode m_containerLid;
    private final Random m_rand;
    private double m_rotationAmount;
    private DialGaugeNode m_pressureMeter;
    private double m_pressureMeterElbowOffset;
    private double m_containerHeightAtExplosion;

    public ParticleContainerNode(MultipleParticleModel multipleParticleModel, ModelViewTransform modelViewTransform, boolean bl, boolean bl2) {
        this.m_model = multipleParticleModel;
        this.m_mvt = modelViewTransform;
        this.m_containmentAreaWidth = StatesOfMatterConstants.CONTAINER_BOUNDS.getWidth();
        this.m_containmentAreaHeight = StatesOfMatterConstants.CONTAINER_BOUNDS.getHeight();
        this.m_rand = new Random();
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void particleAdded(StatesOfMatterAtom statesOfMatterAtom) {
                final ParticleNode particleNode = new ParticleNode(statesOfMatterAtom, ParticleContainerNode.this.m_mvt);
                if (statesOfMatterAtom instanceof HydrogenAtom) {
                    ParticleContainerNode.this.m_lowerParticleLayer.addChild(particleNode);
                } else {
                    ParticleContainerNode.this.m_upperParticleLayer.addChild(particleNode);
                }
                final VoidFunction1<Boolean> voidFunction1 = new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        particleNode.setStrokeEnabled(bl);
                    }
                };
                StatesOfMatterGlobalState.whiteBackground.addObserver(voidFunction1);
                statesOfMatterAtom.addListener(new StatesOfMatterAtom.Adapter(){

                    public void particleRemoved(StatesOfMatterAtom statesOfMatterAtom) {
                        StatesOfMatterGlobalState.whiteBackground.removeObserver(voidFunction1);
                    }
                });
            }

            public void containerSizeChanged() {
                ParticleContainerNode.this.handleContainerSizeChanged();
            }

            public void pressureChanged() {
                if (ParticleContainerNode.this.m_pressureMeter != null) {
                    ParticleContainerNode.this.m_pressureMeter.setValue(ParticleContainerNode.this.m_model.getPressureInAtmospheres());
                }
            }

            public void containerExplodedStateChanged(boolean bl) {
                ParticleContainerNode.this.m_containerHeightAtExplosion = ParticleContainerNode.this.m_model.getParticleContainerHeight();
                ParticleContainerNode.this.m_rotationAmount = 0.031415926535897934 + ParticleContainerNode.this.m_rand.nextDouble() * Math.PI / 50.0;
                if (ParticleContainerNode.this.m_rand.nextBoolean()) {
                    ParticleContainerNode.this.m_rotationAmount = -ParticleContainerNode.this.m_rotationAmount;
                }
            }
        });
        this.m_bottomContainerLayer = new PNode();
        this.m_bottomContainerLayer.setPickable(false);
        this.m_bottomContainerLayer.setChildrenPickable(false);
        this.addChild(this.m_bottomContainerLayer);
        this.m_lowerParticleLayer = new PNode();
        this.m_lowerParticleLayer.setPickable(false);
        this.m_lowerParticleLayer.setChildrenPickable(false);
        this.m_lowerParticleLayer.setOffset(0.0, this.m_containmentAreaHeight);
        this.addChild(this.m_lowerParticleLayer);
        this.m_upperParticleLayer = new PNode();
        this.m_upperParticleLayer.setPickable(false);
        this.m_upperParticleLayer.setChildrenPickable(false);
        this.m_upperParticleLayer.setOffset(0.0, this.m_containmentAreaHeight);
        this.addChild(this.m_upperParticleLayer);
        this.m_middleContainerLayer = new PNode();
        this.m_middleContainerLayer.setPickable(false);
        this.m_middleContainerLayer.setChildrenPickable(true);
        this.addChild(this.m_middleContainerLayer);
        this.m_topContainerLayer = new PNode();
        this.m_topContainerLayer.setPickable(false);
        this.m_topContainerLayer.setChildrenPickable(false);
        this.addChild(this.m_topContainerLayer);
        this.loadMultipleContainerImages();
        if (bl) {
            PointingHandNode pointingHandNode = new PointingHandNode(this.m_model);
            this.m_middleContainerLayer.addChild(pointingHandNode);
            HandleNode handleNode = new HandleNode(50.0, 100.0, Color.YELLOW);
            handleNode.rotate(1.5707963267948966);
            handleNode.setOffset(this.m_containerLid.getWidth() / 2.0 + handleNode.getFullBoundsReference().width / 2.0, 0.0);
            this.m_containerLid.addChild(handleNode);
        }
        if (bl2) {
            this.m_pressureMeter = new DialGaugeNode(0.44 * this.m_containmentAreaWidth, StatesOfMatterStrings.PRESSURE_GAUGE_TITLE, 0.0, 200.0, StatesOfMatterStrings.PRESSURE_GAUGE_UNITS);
            this.m_pressureMeter.setElbowEnabled(true);
            this.m_middleContainerLayer.addChild(this.m_pressureMeter);
            this.updatePressureGauge();
            this.m_pressureMeterElbowOffset = this.m_pressureMeter.getFullBoundsReference().getCenterY();
        }
        double d = 0.0;
        double d2 = -this.m_containmentAreaHeight;
        this.setOffset(d, d2);
        this.setPickable(false);
    }

    public void reset() {
    }

    private void handleContainerSizeChanged() {
        double d = this.m_model.getParticleContainerHeight();
        if (!this.m_model.getContainerExploded()) {
            if (this.m_containerLid.getRotation() != 0.0) {
                this.m_containerLid.setRotation(0.0);
            }
            this.m_containerLid.setOffset((this.m_containmentAreaWidth - this.m_containerLid.getFullBoundsReference().width) / 2.0, this.m_containmentAreaHeight - d - this.m_containerLid.getFullBoundsReference().height / 2.0 + 65.0);
        } else {
            this.m_containerLid.rotateAboutPoint(this.m_rotationAmount, this.m_containmentAreaWidth / 2.0 / this.m_containerLid.getScale(), 0.0);
            double d2 = this.m_containmentAreaHeight - d - this.m_containerLid.getFullBoundsReference().height / 2.0 + 65.0;
            double d3 = this.m_containerLid.getOffset().getY();
            double d4 = this.m_containerLid.getOffset().getX();
            double d5 = d3 > d2 ? d2 : d3;
            this.m_containerLid.setOffset(d4, d5);
        }
        this.updatePressureGauge();
    }

    private void loadMultipleContainerImages() {
        PImage pImage = StatesOfMatterResources.getImageNode("cup_3D_front_70_split_left.png");
        PImage pImage2 = StatesOfMatterResources.getImageNode("cup_3D_front_70_split_right.png");
        PImage pImage3 = StatesOfMatterResources.getImageNode("cup_3D_front_70_split_bottom.png");
        PImage pImage4 = StatesOfMatterResources.getImageNode("cup_3D_front_70_split_top.png");
        PNode pNode = new PNode();
        pNode.addChild(pImage);
        pNode.addChild(pImage4);
        pImage4.setOffset(pImage.getFullBoundsReference().width, 19.0);
        pNode.addChild(pImage3);
        pImage3.setOffset(pImage.getFullBoundsReference().width, pImage.getFullBoundsReference().height - pImage3.getFullBoundsReference().height + 17.0);
        pNode.addChild(pImage2);
        pImage2.setOffset(pImage3.getFullBoundsReference().getMaxX(), 0.0);
        pNode.setScale(this.m_containmentAreaWidth / pNode.getFullBoundsReference().width);
        this.m_topContainerLayer.addChild(pNode);
        pNode.setOffset(0.0, 0.0);
        this.m_containerLid = StatesOfMatterResources.getImageNode("cup_3D_cap_70.png");
        this.m_containerLid.setScale(this.m_containmentAreaWidth / this.m_containerLid.getFullBoundsReference().width);
        this.m_containerLid.setPickable(false);
        this.m_middleContainerLayer.addChild(this.m_containerLid);
        this.m_containerLid.setOffset(0.0, -this.m_containerLid.getFullBoundsReference().height / 2.0 + 65.0);
        PImage pImage5 = StatesOfMatterResources.getImageNode("cup_3D_top_70_fragment.png");
        pImage5.setScale(this.m_containmentAreaWidth / pImage5.getFullBoundsReference().width);
        this.m_bottomContainerLayer.addChild(pImage5);
        pImage5.setOffset(0.0, -(this.m_model.getParticleContainerHeight() * 0.15 / 2.0));
    }

    private void updatePressureGauge() {
        if (this.m_pressureMeter != null) {
            Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
            if (!this.m_model.getContainerExploded()) {
                if (this.m_pressureMeter.getRotation() != 0.0) {
                    this.m_pressureMeter.setRotation(0.0);
                }
                this.m_pressureMeter.setOffset(-this.m_pressureMeter.getFullBoundsReference().width * 0.8, -3000.0);
                this.m_pressureMeter.setElbowHeight(10000.0 - rectangle2D.getHeight() - this.m_pressureMeterElbowOffset);
            } else {
                this.m_pressureMeter.rotateInPlace(-0.15707963267948966);
                this.m_pressureMeter.setOffset(-this.m_pressureMeter.getFullBoundsReference().width * 0.8, -3000.0 - this.m_model.getParticleContainerHeight() + this.m_containerHeightAtExplosion);
            }
        }
    }
}

