/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleNode;
import java.awt.Color;

public class ParticleForceNode
extends ParticleNode {
    public static final Color ATTRACTIVE_FORCE_COLOR = new Color(255, 255, 0, 175);
    public static final Color REPULSIVE_FORCE_COLOR = new Color(255, 0, 255, 175);
    public static final Color TOTAL_FORCE_COLOR = new Color(0, 255, 0, 125);
    private double m_attractiveForce = 0.0;
    private final Vector2DNode m_attractiveForceVectorNode = new Vector2DNode(0.0, 0.0, 1.0E-22, 500.0);
    private double m_repulsiveForce = 0.0;
    private final Vector2DNode m_repulsiveForceVectorNode;
    private final Vector2DNode m_totalForceVectorNode;

    public ParticleForceNode(StatesOfMatterAtom statesOfMatterAtom, ModelViewTransform modelViewTransform, boolean bl, boolean bl2) {
        super(statesOfMatterAtom, modelViewTransform, bl, false, bl2);
        this.m_attractiveForceVectorNode.setMagnitudeAngle(0.0, 0.0);
        this.addChild(this.m_attractiveForceVectorNode);
        this.m_attractiveForceVectorNode.setArrowFillPaint(ATTRACTIVE_FORCE_COLOR);
        this.m_attractiveForceVectorNode.setHeadSize(200.0, 200.0);
        this.m_attractiveForceVectorNode.setTailWidth(100.0);
        this.m_attractiveForceVectorNode.setVisible(false);
        this.m_repulsiveForceVectorNode = new Vector2DNode(0.0, 0.0, 1.0E-22, 500.0);
        this.m_repulsiveForceVectorNode.setMagnitudeAngle(0.0, 0.0);
        this.addChild(this.m_repulsiveForceVectorNode);
        this.m_repulsiveForceVectorNode.setArrowFillPaint(REPULSIVE_FORCE_COLOR);
        this.m_repulsiveForceVectorNode.setHeadSize(200.0, 200.0);
        this.m_repulsiveForceVectorNode.setTailWidth(100.0);
        this.m_repulsiveForceVectorNode.setVisible(false);
        this.m_totalForceVectorNode = new Vector2DNode(0.0, 0.0, 1.0E-22, 1000.0);
        this.m_totalForceVectorNode.setMagnitudeAngle(0.0, 0.0);
        this.addChild(this.m_totalForceVectorNode);
        this.m_totalForceVectorNode.setArrowFillPaint(TOTAL_FORCE_COLOR);
        this.m_totalForceVectorNode.setHeadSize(200.0, 200.0);
        this.m_totalForceVectorNode.setTailWidth(100.0);
        this.m_totalForceVectorNode.setVisible(false);
    }

    public void setForces(double d, double d2) {
        this.m_attractiveForce = d;
        this.m_repulsiveForce = d2;
        this.updateForceVectors();
    }

    public void setShowAttractiveForces(boolean bl) {
        this.m_attractiveForceVectorNode.setVisible(bl);
    }

    public void setShowRepulsiveForces(boolean bl) {
        this.m_repulsiveForceVectorNode.setVisible(bl);
    }

    public void setShowTotalForces(boolean bl) {
        this.m_totalForceVectorNode.setVisible(bl);
    }

    protected void updateForceVectors() {
        this.m_attractiveForceVectorNode.setMagnitudeAngle(this.m_attractiveForce, 0.0);
        this.m_repulsiveForceVectorNode.setMagnitudeAngle(this.m_repulsiveForce, 0.0);
        this.m_totalForceVectorNode.setMagnitudeAngle(this.m_attractiveForce + this.m_repulsiveForce, 0.0);
    }
}

