/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PointingHandNode
extends PNode {
    private final PImage m_fingerImageNode;
    private final MultipleParticleModel m_model;
    private double m_mouseMovementAmount;
    private double m_containerSizeAtDragStart;
    private boolean m_mouseOver = false;
    private boolean m_beingDragged = false;
    private final PNode m_hintNode;

    public PointingHandNode(MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
        double d = rectangle2D.getWidth() * 0.55;
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void containerSizeChanged() {
                PointingHandNode.this.handleContainerSizeChanged();
            }
        });
        this.m_fingerImageNode = StatesOfMatterResources.getImageNode("finger-4.png");
        double d2 = d / this.m_fingerImageNode.getFullBoundsReference().width;
        this.m_fingerImageNode.scale(d2);
        this.m_fingerImageNode.setPickable(true);
        this.m_fingerImageNode.addInputEventListener(new CursorHandler(8));
        this.m_hintNode = new MovementHintNode(this.m_model){
            {
                this.setOffset(PointingHandNode.this.m_fingerImageNode.getFullBoundsReference().getMaxX() + 150.0, PointingHandNode.this.m_fingerImageNode.getFullBoundsReference().getMaxY() - this.getFullBoundsReference().getHeight() - 1000.0);
                this.setVisible(false);
            }
        };
        this.addChild(this.m_hintNode);
        this.m_fingerImageNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
                PointingHandNode.this.m_mouseOver = true;
                PointingHandNode.this.updateHintVisibility();
            }

            public void mouseExited(PInputEvent pInputEvent) {
                PointingHandNode.this.m_mouseOver = false;
                PointingHandNode.this.updateHintVisibility();
            }
        });
        this.m_fingerImageNode.addInputEventListener(new PDragEventHandler(){

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                PointingHandNode.this.handleMouseStartDragEvent();
            }

            public void drag(PInputEvent pInputEvent) {
                PointingHandNode.this.handleMouseDragEvent(pInputEvent);
            }

            public void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                PointingHandNode.this.handleMouseEndDragEvent();
            }
        });
        this.addChild(this.m_fingerImageNode);
        this.setOffset(rectangle2D.getX() + rectangle2D.getWidth() * 0.3, -this.getFullBoundsReference().height);
    }

    private void handleMouseDragEvent(PInputEvent pInputEvent) {
        PNode pNode = pInputEvent.getPickedNode();
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
        pNode.localToParent(pDimension);
        this.m_mouseMovementAmount += pDimension.getHeight();
        this.m_model.setTargetParticleContainerHeight(this.m_containerSizeAtDragStart - this.m_mouseMovementAmount);
    }

    private void handleMouseStartDragEvent() {
        this.m_beingDragged = true;
        this.m_mouseMovementAmount = 0.0;
        this.m_containerSizeAtDragStart = this.m_model.getParticleContainerHeight();
        this.updateHintVisibility();
    }

    private void handleMouseEndDragEvent() {
        this.m_model.setTargetParticleContainerHeight(this.m_model.getParticleContainerHeight());
        this.m_beingDragged = false;
        this.updateHintVisibility();
    }

    private void handleContainerSizeChanged() {
        Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
        if (!this.m_model.getContainerExploded()) {
            this.setOffset(this.getFullBoundsReference().x, 10000.0 - rectangle2D.getHeight() - this.getFullBoundsReference().height);
        } else {
            this.setOffset(this.getFullBoundsReference().x, 10000.0 - rectangle2D.getHeight() * 2.0 - this.getFullBoundsReference().height);
        }
    }

    private void updateHintVisibility() {
        this.m_hintNode.setVisible(this.m_mouseOver || this.m_beingDragged);
    }

    private static class MovementHintNode
    extends PNode {
        private static final Color ARROW_COLOR = Color.GREEN;
        private static final Color INVISIBLE_ARROW_COLOR = new Color(0, 0, 0, 0);
        private final ArrowNode m_upArrowNode;
        private final ArrowNode m_downArrow;
        private final MultipleParticleModel m_model;

        private MovementHintNode(MultipleParticleModel multipleParticleModel) {
            this.m_model = multipleParticleModel;
            this.m_upArrowNode = new ArrowNode(new Point2D.Double(500.0, 1000.0), new Point2D.Double(500.0, 0.0), 500.0, 1000.0, 500.0){
                {
                    this.setPaint(ARROW_COLOR);
                }
            };
            this.addChild(this.m_upArrowNode);
            this.m_downArrow = new ArrowNode(new Point2D.Double(500.0, 1250.0), new Point2D.Double(500.0, 2250.0), 500.0, 1000.0, 500.0){
                {
                    this.setPaint(ARROW_COLOR);
                }
            };
            this.addChild(this.m_downArrow);
            multipleParticleModel.addListener(new MultipleParticleModel.Adapter(){

                public void containerSizeChanged() {
                    MovementHintNode.this.updateArrowVisibility();
                }
            });
            this.setPickable(false);
            this.setChildrenPickable(false);
        }

        private void updateArrowVisibility() {
            if (this.m_model.getParticleContainerHeight() == 10000.0) {
                this.m_upArrowNode.setPaint(ARROW_COLOR);
                this.m_upArrowNode.setVisible(false);
            } else if (this.m_model.getParticleContainerHeight() == 0.0) {
                this.m_upArrowNode.setPaint(INVISIBLE_ARROW_COLOR);
                this.m_upArrowNode.setVisible(false);
            } else {
                this.m_upArrowNode.setVisible(true);
                this.m_upArrowNode.setVisible(true);
            }
        }
    }
}

